import datetime

from sandbox import sdk2
from sandbox.projects.ydo import ydo_releasers

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view


class YdoCalculateYangBonusExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoCalculateYangBonus(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(generate_view(ydo_calculate_yang_bonus=YdoCalculateYangBonusExecutable, check_owner=True, with_environ=True)):
        with sdk2.parameters.Group('KIKIMR_CONNECTION'):
            ydb_host = sdk2.parameters.String('Host', required=True)
            ydb_home = sdk2.parameters.String('Home', required=True)
            ydb_database = sdk2.parameters.String('Database', required=True)
            ydb_port = sdk2.parameters.Integer('Port', default=2135)
        with sdk2.parameters.Group('YANG'):
            yang_host = sdk2.parameters.String('Yang host', required=True)
            project_id = sdk2.parameters.String('Project id', required=True)
            pool_id = sdk2.parameters.String('Pool id', default='')

        logging_config = sdk2.parameters.String('LoggingConfig')

    def add_param_to_cmd(self, cmd, name, parameter):
        if parameter:
            cmd += [name, parameter]

    def on_execute(self):
        cmd = [
            self.Parameters.ydo_calculate_yang_bonus_path,
            '--kikimr-host', self.Parameters.ydb_host,
            '--kikimr-home', self.Parameters.ydb_home,
            '--kikimr-database', self.Parameters.ydb_database,
            '--kikimr-port', str(self.Parameters.ydb_port),

            '--yang_host', self.Parameters.yang_host,
            '--project_id', self.Parameters.project_id,
            '--pool_id', self.Parameters.pool_id,
        ]
        execute_cmd(cmd, 'calculate_yang_bonus', 'calculate_yang_bonus failed', env=self.Parameters.get_environ())
