import os
import tarfile
import tempfile

from sandbox import sdk2
from sandbox.projects.geobase.Geodata6BinStable.resource import GEODATA6BIN_STABLE
from sandbox.projects.resource_types import GEODATATZDATA_STABLE
from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.default_multislot_task import YdoMutlihostTask


class YdoReminderCallBacks(YdoMutlihostTask):
    class Parameters(YdoMutlihostTask.Parameters):
        description = 'Process call center reminder call backs'

        binary = sdk2.parameters.Resource('call_center_reminders_call_back binary', required=True)

        ydb_host = sdk2.parameters.String('Ydb host', default='ydb-ru.yandex.net', required=True)
        ydb_database = sdk2.parameters.String('Ydb database', default='/ru/services/prod/services', required=True)
        ydb_home = sdk2.parameters.String('Ydb home', default='runtime', required=True)
        ydb_vault_token = sdk2.parameters.String('Ydb token name in the vault', default='ydb-token', required=True)
        yt_vault_token = sdk2.parameters.String('Yt token name in the vault', default='yt-token', required=True)

        yt_table_path = sdk2.parameters.String(
            'Call center recalls table path',
            default='//home/offline_data/CallCenter/uslugi/incoming_calls/recalls',
            required=True,
        )
        geobase = sdk2.parameters.Resource(
            'Geobase binary (geodata6.bin)',
            resource_type=GEODATA6BIN_STABLE,
            required=True,
        )
        tzdata = sdk2.parameters.Resource(
            'Timezone data archive (tzdata.tar.gz)',
            resource_type=GEODATATZDATA_STABLE,
            required=True,
        )

    def on_execute(self):
        geobase_path = str(sdk2.ResourceData(self.Parameters.geobase).path)
        tzdata_path = str(sdk2.ResourceData(self.Parameters.tzdata).path)

        extracted_tzdata_dir = tempfile.mkdtemp()
        tarfile.open(tzdata_path).extractall(extracted_tzdata_dir)

        env = os.environ.copy()
        env['YDB_TOKEN'] = sdk2.Vault.data(self.owner, self.Parameters.ydb_vault_token)
        env['YT_TOKEN'] = sdk2.Vault.data(self.owner, self.Parameters.yt_vault_token)

        execute_cmd([
            str(sdk2.ResourceData(self.Parameters.binary).path),
            '--ydb_host', self.Parameters.ydb_host,
            '--ydb_database', self.Parameters.ydb_database,
            '--ydb_home', self.Parameters.ydb_home,
            '--yt_table_path', self.Parameters.yt_table_path,
            '--geobase_path', geobase_path,
            '--geobase_tzdata_path', '{}/zones_bin'.format(extracted_tzdata_dir)
        ], 'call_center_reminders_call_back', 'call_center_reminders_call_back failed', env=env)
