from sandbox import sdk2
from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view, with_config
from sandbox.projects.ydo import resource_types
from sandbox.projects.ydo import build

from sandbox.projects.ydo.solomon_mixin import SolomonMixinV2


class YdoCheckNirvanaFoldersExecutable(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = resource_types.ydo_releasers
    arcadia_build_path = 'ydo/devops/yt_tools/check_nirvana_folders'
    executable = True

    binary_path = sdk2.parameters.String(default='check_nirvana_folders')


class BuildYdoCheckNirvanaFoldersExecutable(build.YdoYaMakeTemplate):
    class Parameters(build.get_project_params([YdoCheckNirvanaFoldersExecutable])):
        pass


class YdoCheckNirvanaFolders(sdk2.Task, SolomonMixinV2):
    class Parameters(
        with_config(
            generate_view(
                check_nirvana_folders=YdoCheckNirvanaFoldersExecutable, check_owner=True, with_environ=True,
                default_secret_env_vars={
                    'YT_TOKEN': 'yt-token',
                }
            ),
            'ydo/devops/yt_tools/check_nirvana_folders',
            [
                ('ydo-dev', 'whitelist_ydo_dev.yaml'),
                ('ydo-dev-users', 'whitelist_ydo_dev_users.yaml'),
                ('ydo', 'whitelist_ydo.yaml'),
                ('ydo-users', 'whitelist_ydo_users.yaml'),
            ]
        )
    ):
        pass

    def on_execute(self):
        cmd = [self.Parameters.check_nirvana_folders_path, '--config', self.Parameters.config_path, '--log-to-stderr']
        execute_cmd(cmd, 'check_nirvana_folders',
                    'check_nirvana_folders failed',
                    env=self.Parameters.get_environ())

    def on_break(self, *args, **kwargs):
        SolomonMixinV2.on_break(self, *args, **kwargs)
        super(YdoCheckNirvanaFolders, self).on_break(*args, **kwargs)

    def on_finish(self, *args, **kwargs):
        SolomonMixinV2.on_finish(self, *args, **kwargs)
        super(YdoCheckNirvanaFolders, self).on_finish(*args, **kwargs)
