from sandbox import sdk2

from sandbox.projects.geobase.Geodata6BinStable.resource import GEODATA6BIN_STABLE
from sandbox.projects.ydo import execute_cmd, ydo_releasers, YdoFeaturesJson, YdoOrderCustomizerJson
from sandbox.projects.ydo.parameters_view import generate_view, ResourceWrapper
from sandbox.projects.ydo.rubrics_merger.YdoRubricsMerger import YdoMergedRubricsSmallDump


class YdoClarifierAnswersValidationExecutable(sdk2.Resource):
    """
    Validate OrderClarifier config
    """

    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoClarifierAnswersValidationResults(sdk2.Resource):
    """
    Validation results
    """

    releasable = False


class YdoClarifierAnswersValidation(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 32

    class Parameters(
        generate_view(
            ydo_clarifier_answer_validation=YdoClarifierAnswersValidationExecutable,
            rubrics_json=YdoMergedRubricsSmallDump,
            features_json=YdoFeaturesJson,
            geobase_file=ResourceWrapper(GEODATA6BIN_STABLE),
            check_owner=True,
            with_environ=True,
        )
    ):
        input_config = sdk2.parameters.Resource(
            'Input config',
            resource_type=YdoOrderCustomizerJson,
            required=True,
        )
        ydb_host = sdk2.parameters.String('YDB host', required=True)
        ydb_port = sdk2.parameters.Integer('YDB port', default=2135)
        ydb_database = sdk2.parameters.String('YDB database', required=True)
        ydb_home = sdk2.parameters.String('YDB home', required=True)

        parallel = sdk2.parameters.Integer('Max workers count', default=32)
        min_samples_count = sdk2.parameters.Integer('Optimization samples count', default=1)

        group_max_samples = sdk2.parameters.Integer('Number of group samples', default=5)
        checkbox_max_samples = sdk2.parameters.Integer('Number of checkbox samples', default=5)
        quantity_max_random = sdk2.parameters.Integer('Number of quantity samples', default=2)

        time_limit = sdk2.parameters.Integer('Time limit before enabling optimization', default=600)

    def on_execute(self):
        results_json = YdoClarifierAnswersValidationResults(
            self, 'config_validation_results.json', 'config_validation_results.json'
        )
        results_json_data = sdk2.ResourceData(results_json)

        cmd = [
            self.Parameters.ydo_clarifier_answer_validation_path,
            '--input-config',
            str(sdk2.ResourceData(self.Parameters.input_config).path),
            '--rubrics-json',
            self.Parameters.rubrics_json_path,
            '--features-json',
            self.Parameters.features_json_path,
            '--geobase-file',
            self.Parameters.geobase_file_path,
            '--results-json',
            str(results_json_data.path),
            '--ydb_host',
            self.Parameters.ydb_host,
            '--ydb_port',
            str(self.Parameters.ydb_port),
            '--ydb_database',
            self.Parameters.ydb_database,
            '--ydb_home',
            self.Parameters.ydb_home,
            '--parallel',
            str(self.Parameters.parallel),
            '--min-samples-count',
            str(self.Parameters.min_samples_count),
            '--group-max-samples',
            str(self.Parameters.group_max_samples),
            '--checkbox-max-samples',
            str(self.Parameters.checkbox_max_samples),
            '--quantity-max-random',
            str(self.Parameters.quantity_max_random),
            '--time-limit',
            str(self.Parameters.time_limit),
        ]

        execute_cmd(
            cmd, 'clarifier_answer_validation', 'clarifier_answer_validation failed', env=self.Parameters.get_environ()
        )

        results_json_data.ready()
