from sandbox import sdk2

from sandbox.projects.ydo import execute_cmd, ydo_releasers
from sandbox.projects.ydo.parameters_view import generate_view


class YdoClearYdbTableExecutable(sdk2.Resource):
    """
        Delete old rows from ydb table
    """
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoClearYdbTable(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(generate_view(ydo_clear_ydb_table_executable=YdoClearYdbTableExecutable, check_owner=True, with_environ=True)):
        table_name = sdk2.parameters.String('Table name', required=True)
        timestamp_column = sdk2.parameters.String('Name of column with timestamp', required=True)
        age = sdk2.parameters.Integer('Max age of row in seconds', required=True)

        yt_backup_path = sdk2.parameters.String('Dir with backups on YT', required=True)
        yt_proxy = sdk2.parameters.String('YT proxy', default='hahn')

        ydb_host = sdk2.parameters.String('YDB host', required=True)
        ydb_port = sdk2.parameters.Integer('YDB port', default=2135)
        ydb_database = sdk2.parameters.String('YDB database', required=True)
        ydb_home = sdk2.parameters.String('YDB home', required=True)

    def on_execute(self):
        cmd = [
            self.Parameters.ydo_clear_ydb_table_executable_path,
            '--table_name', self.Parameters.table_name,
            '--timestamp_column', self.Parameters.timestamp_column,
            '--age', str(self.Parameters.age),
            '--yt_backup_path', self.Parameters.yt_backup_path,
            '--yt_proxy', self.Parameters.yt_proxy,
            '--ydb_host', self.Parameters.ydb_host,
            '--ydb_port', str(self.Parameters.ydb_port),
            '--ydb_database', self.Parameters.ydb_database,
            '--ydb_home', self.Parameters.ydb_home,
        ]

        execute_cmd(cmd, 'clear_ydb_table', 'clear failed', env=self.Parameters.get_environ())
