import os


def get_table_path(config, tablename):
    return os.path.join(config["tables"].get("home", "/"), config["tables"][tablename]["path"])


def get_table_types(config, tablename):
    return list(map(lambda column: {field: column[field] for field in ["name", "type"]}, config["tables"][tablename]["schema"]))


def get_primary_columns(config, tablename):
    return list(map(lambda column: column["name"], filter(lambda column: column.get("primary_key", False), config["tables"][tablename]["schema"])))


def get_backup_folder(config):
    return config["backup"]["folder"]


def get_database_host(config):
    return config["connection"]["host"]


def get_database_port(config):
    return config["connection"]["port"]


def get_database_host_with_port(config):
    return "{}:{}".format(get_database_host(config), get_database_port(config))
