import sandbox.projects.ydo.process_generator as process_generator

pg = process_generator.ProcessGenerator(
    'ydo/tools/partner_flow/create_drive_car_wash_orders',
    config_spec=process_generator.ConfigSpec(
        'ydo/tools/partner_flow/create_drive_car_wash_orders/configs',
        [
            ('production', 'production.yaml'),
            ('production_carousel', 'production_carousel.yaml'),
            ('ydo_production_drive_prestable', 'ydo_production_drive_prestable.yaml'),
            ('testing', 'testing.yaml'),
        ],
        auto_post_process=False,
    ),
    use_yav_secrets=False,
)


class YdoCreateDriveCarWashOrdersExecutable(pg.generate_resource()):
    pass


class BuildYdoCreateDriveCarWashOrdersExecutable(pg.generate_build_task(YdoCreateDriveCarWashOrdersExecutable)):
    pass


class YdoCreateDriveCarWashOrders(pg.generata_task(YdoCreateDriveCarWashOrdersExecutable)):
    pass
