import logging

from sandbox import sdk2
from sandbox.common.types import misc as ctm
from sandbox.projects.ydo import execute_cmd, ydo_releasers
from sandbox.projects.ydo.parameters_view import generate_view
from sandbox.sandboxsdk.environments import PipEnvironment


class YdoCreateTransactionsForPayoffsHandler(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers
    arcadia_build_path = "ydo/tools/balance/create_transactions_for_payoffs/bin"
    executable = True

    binary_path = sdk2.parameters.String(default='create_transactions_for_payoffs')


class YdoCreateTransactionsForPayoffs(sdk2.Task):
    """Task that creates balance_transactions for payoffs_for_external_workers"""

    class Parameters(generate_view(
        processor=YdoCreateTransactionsForPayoffsHandler,
        check_owner=True,
    )):
        environment = sdk2.parameters.String('Environment', required=True)

    class Requirements(sdk2.Requirements):
        cores = 1
        dns = ctm.DnsType.DNS64
        environments = (
            PipEnvironment('requests'),
        )

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        logging.info('Starting executing create_transactions_for_payoffs')

        execute_cmd(
            [
                str(self.Parameters.processor_path),
                '--environment', str(self.Parameters.environment),
            ],
            'create_transactions_for_payoffs',
            'Failed to create_transactions_for_payoffs',
        )

        logging.info('Done')
