from sandbox import sdk2
from sandbox.projects.ydo import ydo_releasers
from sandbox.projects.ydo.parameters_view import generate_view, with_config
from sandbox.projects.ydo import execute_cmd


class YDODBAutoDocumentationExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YDODBAutoDocumentation(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(with_config(
            generate_view(
                ydo_db_auto_documentation=YDODBAutoDocumentationExecutable,
                check_owner=True,
                with_environ=True
            ),
            configs_folder='ydo/database/config_generator/lib',
            configs_choices=[
                ('tables.json', 'tables.json')
            ],
        )
    ):
        oauth_token_name = sdk2.parameters.String("oauth token name", required=True)
        url_name = sdk2.parameters.String("url name")

    def on_execute(self):
        cmd = [
            self.Parameters.ydo_db_auto_documentation_path,
            '--oauth_token_name', self.Parameters.oauth_token_name,
            '--url_name', self.Parameters.url_name,
            '--tables_path', self.Parameters.config_path,
        ]

        execute_cmd(cmd, 'ydo_db_auto_documentation', 'ydo_db_auto_documentation failed', env=self.Parameters.get_environ())
