import logging
import os

from sandbox import sdk2

from sandbox.projects.ydo import ydo_releasers, execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view, ResourceWrapper
from sandbox.projects.geobase.Geodata6BinStable.resource import GEODATA6BIN_STABLE
from sandbox.projects.geosearch.CleanupYtFolder import clean_folder


# Resource types
class YdoMergeGeoGeometryExecutable(sdk2.Resource):
    """
        Merge geo geometry
    """
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoMergeGeoGeometry(sdk2.Task):
    '''Merge geo for areasList and addressesList for workers'''

    class Parameters(generate_view(executable=YdoMergeGeoGeometryExecutable, geobase_snapshot=ResourceWrapper(GEODATA6BIN_STABLE))):

        yt_backup_dir = sdk2.parameters.String('Path to database backup on YT', required=True)

        res_dir = sdk2.parameters.String('Resulting directory', required=True)

        prev_data_path = sdk2.parameters.String('Previous calc path on YT')

        link_current = sdk2.parameters.Bool('Link table to current', default=True)

        workers_to_sprav_companies_result_path = sdk2.parameters.String('Path to result of workers_to_sprav_companies querry')

        altay_company_to_chain_path = sdk2.parameters.String('Path to sprav company_to_chain table')

        clear_linked_sprav_online_orgs_addresses = sdk2.parameters.Bool('Remove addresses, areas and main_address from workers linked with sprav online orgs', default=False)

    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def merge_geos(self):
        yt_token = sdk2.Vault.data(self.owner, 'yt-token')

        env = os.environ.copy()
        env['YT_TOKEN'] = yt_token
        env['YT_PROXY'] = 'hahn.yt.yandex.net'
        env['YT_LOG_LEVEL'] = 'INFO'

        logging.info('Merging...')
        executable = self.Parameters.executable_path
        execute_cmd(
            [
                executable,
                '--db_dump_dir', self.Parameters.yt_backup_dir,
                '--dump_from_yt',
                '--geobase_file', self.Parameters.geobase_snapshot_path,
                '--res_dir', self.Parameters.res_dir,
            ]
            + (['--prev_data_path', self.Parameters.prev_data_path] if self.Parameters.prev_data_path else [])
            + (['--link_current'] if self.Parameters.link_current else [])
            + (['--workers_to_sprav_companies_result_path', self.Parameters.workers_to_sprav_companies_result_path] if self.Parameters.workers_to_sprav_companies_result_path else [])
            + (['--clear_linked_sprav_online_orgs_addresses'] if self.Parameters.clear_linked_sprav_online_orgs_addresses else [])
            + (['--altay_company_to_chain_path', self.Parameters.altay_company_to_chain_path] if self.Parameters.altay_company_to_chain_path else []),
            'geometry_merger',
            'Failed to merge geometries',
            env=env
        )

    def on_execute(self):
        with self.memoize_stage.merge_geos:
            self.merge_geos()

        with self.memoize_stage.clean_folder:
            clean_folder(self, self.Parameters.res_dir)

        logging.info('Done')
