from sandbox import sdk2
from sandbox.projects.ydo import (
    ydo_releasers,
)

from sandbox.projects.ydo.direct.db_processor import YdoDirectDbProcessor, gen_parameters


class YdoDirectCampaignsUpdaterExecutable(sdk2.Resource):
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoDirectCampaignsUpdater(YdoDirectDbProcessor):
    class Parameters(gen_parameters(YdoDirectCampaignsUpdaterExecutable)):
        pass

    def additional_cmd_args(self):
        env = self.Parameters.get_environ()
        res = []
        res.extend(['--tvm_secret', env['TVM_SECRET']])
        return res
