import logging
from sandbox import sdk2
from sandbox.projects.geobase.Geodata6BinStable.resource import GEODATA6BIN_STABLE
from sandbox.projects.resource_types import OTHER_RESOURCE
from sandbox.projects.ydo import (
    execute_cmd,
    ydo_releasers,
)

from sandbox.projects.ydo.parameters_view import generate_view, ResourceWrapper
from sandbox.projects.ydo import YdoRubricsDump


class YdoDirectClientErrorsCalcerExecutable(sdk2.Resource):
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoDirectClientErrorsCalcer(sdk2.Task):
    class Parameters(generate_view(
        executable=YdoDirectClientErrorsCalcerExecutable,
        rubrics_json=YdoRubricsDump,
        geobase=ResourceWrapper(GEODATA6BIN_STABLE),
        check_owner=True,
        with_environ=True,
        default_env_vars={
            'YT_PROXY': 'hahn.yt.yandex.net',
            'YT_LOG_LEVEL': 'INFO',
        },
        default_secret_env_vars={
            'YT_TOKEN': 'yt-token',
            'TVM_SECRET': 'ydo_tvm_secret_prod',
            'SOLOMON_TOKEN': 'solomon-token',
        },
    )):

        db_dump_dir = sdk2.parameters.String('Path to YDB dump in YT', required=True)
        out_table = sdk2.parameters.String('YT table to store results')

        logging_level = sdk2.parameters.Integer('Logging level', default=logging.INFO)

        enable_monitoring = sdk2.parameters.Bool('Enable solomon monitoring', required=True, default=False)

        solomon_project = sdk2.parameters.String('Solomon project', required=False, default='ydo')

        solomon_cluster = sdk2.parameters.String('Solomon cluster', required=False, default='direct')

        solomon_service = sdk2.parameters.String('Solomon service', required=False, default='direct_client_errors')

        solomon_type = sdk2.parameters.String('Solomon type', required=False, default='prod')

    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        logging.info('Starting executable...')
        puid2status_file = 'puid2status'
        env = self.Parameters.get_environ()
        cmd = [
            self.Parameters.executable_path,
            '--db_dump_dir', self.Parameters.db_dump_dir,
            '--rubrics_json', self.Parameters.rubrics_json_path,
            '--geobase_file', self.Parameters.geobase_path,
            '--tvm_secret', env['TVM_SECRET'],
            '--dump_stats', puid2status_file,
        ]
        if self.Parameters.out_table:
            cmd += ['--dump_stats_yt', self.Parameters.out_table]
        if self.Parameters.logging_level is not None:
            cmd += ['--logging_level', str(self.Parameters.logging_level)]
        if self.Parameters.enable_monitoring:
            cmd += [
                '--enable_monitoring',
                '--solomon_project', self.Parameters.solomon_project,
                '--solomon_cluster', self.Parameters.solomon_cluster,
                '--solomon_service', self.Parameters.solomon_service,
                '--solomon_type', self.Parameters.solomon_type,
            ]
        execute_cmd(cmd, 'executable', 'Failed', env=env)
        sdk2.ResourceData(OTHER_RESOURCE(self, puid2status_file, puid2status_file)).ready()
        logging.info('Done')
