from sandbox import sdk2
from sandbox.projects.ydo import (
    ydo_releasers,
)

from sandbox.projects.ydo.direct.db_processor import YdoDirectDbProcessor, gen_parameters


class YdoDirectCalcMetricsExecutable(sdk2.Resource):
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoDirectCalcMetrics(YdoDirectDbProcessor):
    class Parameters(gen_parameters(YdoDirectCalcMetricsExecutable)):
        out_yt_dir = sdk2.parameters.String('Yt directory to store results', required=True, default='//home/ydo/direct_promotion/daily_metrics_source/')
        forecaster_clicks_coeff = sdk2.parameters.Float('Forecaster clicks coeff', default=1.)

    def additional_cmd_args(self):
        res = ['--out_yt_dir', self.Parameters.out_yt_dir]
        res += ['--forecaster_clicks_coeff', str(self.Parameters.forecaster_clicks_coeff)]
        return res
