import logging

from sandbox import sdk2

from sandbox.projects.geobase.Geodata6BinStable.resource import GEODATA6BIN_STABLE
from sandbox.projects.ydo import (
    execute_cmd,
)
from sandbox.projects.ydo.parameters_view import generate_view, ResourceWrapper
from sandbox.projects.ydo import YdoRubricsDump


def gen_parameters(executable_class):
    class Parameters(generate_view(
        executable=executable_class,
        rubrics_json=YdoRubricsDump,
        geobase=ResourceWrapper(GEODATA6BIN_STABLE),
        check_owner=True,
        with_environ=True,
        default_env_vars={
            'YT_PROXY': 'hahn.yt.yandex.net',
            'YT_LOG_LEVEL': 'INFO',
        },
        default_secret_env_vars={
            'YT_TOKEN': 'yt-token',
            'YDB_TOKEN': 'ydb-token',
            'TVM_SECRET': 'ydo_tvm_secret_prod',
            'SOLOMON_TOKEN': 'solomon-token',
        },
    )):

        ydb_host = sdk2.parameters.String('YDB host', required=True)

        ydb_port = sdk2.parameters.Integer('YDB port', required=True, default=2135)

        ydb_database = sdk2.parameters.String('YDB database', required=True)

        ydb_home = sdk2.parameters.String('Path to YDB home dir', required=True)

        db_dump_dir = sdk2.parameters.String('Path to YDB dump in YT', required=True)

        direct_use_prod_api = sdk2.parameters.Bool('Use prod api', required=True, default=False)

        logging_level = sdk2.parameters.Integer('Logging level', default=logging.INFO)

        enable_monitoring = sdk2.parameters.Bool('Enable solomon monitoring', required=True, default=False)

        solomon_project = sdk2.parameters.String('Solomon project', required=False, default='ydo')

        solomon_cluster = sdk2.parameters.String('Solomon cluster', required=False, default='direct')

        solomon_service = sdk2.parameters.String('Solomon service', required=False, default='simple_monitoring')

        solomon_type = sdk2.parameters.String('Solomon type', required=False)

        direct_user_oauth_aes_key_secret_name = sdk2.parameters.String('Yav secret name for direct user oauth tokens', default='sec-01dzrtngaz5yqpc1g4hmy1qd55')

        cmd_params = sdk2.parameters.String('Additional cmd args')

    return Parameters


class YdoDirectDbProcessor(sdk2.Task):

    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def additional_cmd_args(self):
        return []

    def on_execute(self):
        logging.info('Starting executable...')
        cmd = [
            self.Parameters.executable_path,
            '--ydb_host', self.Parameters.ydb_host,
            '--ydb_port', str(self.Parameters.ydb_port),
            '--ydb_database', self.Parameters.ydb_database,
            '--ydb_home', self.Parameters.ydb_home,
            '--db_dump_dir', self.Parameters.db_dump_dir,
            '--rubrics_json', self.Parameters.rubrics_json_path,
            '--geobase_file', self.Parameters.geobase_path,
        ]
        if self.Parameters.direct_user_oauth_aes_key_secret_name:
            cmd += ['--direct_user_oauth_aes_key', sdk2.yav.Secret(self.Parameters.direct_user_oauth_aes_key_secret_name).data()['ydo_direct_token_aes_secret_key']]
        if self.Parameters.direct_use_prod_api:
            cmd += ['--direct_use_prod_api']
        if self.Parameters.logging_level is not None:
            cmd += ['--logging_level', str(self.Parameters.logging_level)]
        if self.Parameters.enable_monitoring:
            cmd += [
                '--enable_monitoring',
                '--solomon_project', self.Parameters.solomon_project,
                '--solomon_cluster', self.Parameters.solomon_cluster,
                '--solomon_service', self.Parameters.solomon_service,
                '--solomon_type', self.Parameters.solomon_type,
            ]
        cmd += self.Parameters.cmd_params.split() if self.Parameters.cmd_params else []
        cmd += self.additional_cmd_args()
        execute_cmd(cmd, 'executable', 'Failed', env=self.Parameters.get_environ())
        logging.info('Done')
