# -*- coding: utf-8 -*-
from sandbox.projects.ydo.solomon_mixin import SolomonMixinV2
from sandbox.projects.common.geosearch.base_update import generate_base_update_task_sdk2
from sandbox.projects.ydo.dispatch.YdoRedispatcherMonitoring import YdoRedispatcherMonitoring

BaseUpdate = generate_base_update_task_sdk2(YdoRedispatcherMonitoring, release_subject="Update YdoRedispatcherMonitoring", force_rebuild=True)


class UpdateYdoRedispatcherMonitoring(BaseUpdate, SolomonMixinV2):
    """
        Update YdoRedispatcherMonitoring
    """

    class Requirements(BaseUpdate.Requirements):
        cores = 1

        class Caches(BaseUpdate.Requirements.Caches):
            pass

    def on_break(self, *args, **kwargs):
        SolomonMixinV2.on_break(self, *args, **kwargs)
        super(UpdateYdoRedispatcherMonitoring, self).on_break(*args, **kwargs)

    def on_finish(self, *args, **kwargs):
        SolomonMixinV2.on_finish(self, *args, **kwargs)
        super(UpdateYdoRedispatcherMonitoring, self).on_finish(*args, **kwargs)
