from sandbox import sdk2
from sandbox.sandboxsdk import environments

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view
from sandbox.projects.ydo.resource_types import YdoDispatchGeotrackingBinary, YdoDispatchGeotrackingDirectory

import datetime


class YdoDispatchGeotrackingAnalyzerTask(sdk2.Task):
    class Requirements(sdk2.Requirements):
        environments = [
            environments.PipEnvironment('yandex-yt'),
        ]
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(
        generate_view(
            geotracking_executable=YdoDispatchGeotrackingBinary,
            check_owner=True,
            with_environ=True,
        )
    ):
        input_table = sdk2.parameters.String(
            "Employees geo info table",
            required=True,
        )
        out_table = sdk2.parameters.String(
            "Output table prefix",
            required=True,
        )
        spec_id = sdk2.parameters.String(
            "Specialization id",
            required=True,
        )
        end_date = sdk2.parameters.String(
            "Latest track date",
        )
        days_num = sdk2.parameters.Integer("Dates to count", default=1)
        draw_speeds = sdk2.parameters.Bool("Draw employees tracks", default=False)

    def on_execute(self):
        env = self.Parameters.get_environ()
        env["YT_TOKEN"] = sdk2.Vault.data(self.owner, "yt-token")

        resource = YdoDispatchGeotrackingDirectory(self, "geotracking directory", "geotracking")
        data = sdk2.ResourceData(resource)

        end_date = self.Parameters.end_date
        if not end_date:
            end_date = str(datetime.date.today() - datetime.timedelta(days=1))

        cmd = [
            self.Parameters.geotracking_executable_path,
            '--table',
            self.Parameters.input_table,
            '--out_directory',
            self.Parameters.out_table,
            '--spec_id',
            self.Parameters.spec_id,
            '--end_date',
            end_date,
            '--days_num',
            str(self.Parameters.days_num),
            '--tracks_path',
            'geotracking',
        ]

        if self.Parameters.draw_speeds:
            cmd.append('--draw_speeds')

        execute_cmd(cmd, "YdoDispatchGeotrackingAnalyzerTask", "YdoDispatchGeotrackingAnalyzerTask failed", env=env)

        data.ready()
