from sandbox import sdk2
from sandbox.sandboxsdk import environments

from sandbox.projects.ydo.resource_types import YdoDispatchTesterResult, YdoDispatchTesterResultDiff
from sandbox.common.errors import TaskFailure

import json


min_diff_by_spec = {
    'dostavka-vody-6508': -0.03,
}


class YdoDispatchMetricsAnalyzerTask(sdk2.Task):
    class Requirements(sdk2.Requirements):
        environments = [
            environments.PipEnvironment('yandex-yt'),
        ]
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        base_metrics = sdk2.parameters.Resource(
            'Baseline metrics', resource_type=YdoDispatchTesterResult, required=True
        )
        test_metrics = sdk2.parameters.Resource('Test metrics', resource_type=YdoDispatchTesterResult, required=True)

    def on_execute(self):

        resource = YdoDispatchTesterResultDiff(self, "dispatch metrics diff file", "dispatch_metrics_diff.json")
        data = sdk2.ResourceData(resource)

        base = json.loads(open(str(sdk2.ResourceData(self.Parameters.base_metrics).path)).read())
        test = json.loads(open(str(sdk2.ResourceData(self.Parameters.test_metrics).path)).read())

        spec_id = base['specialization']
        min_diff = min_diff_by_spec.get(spec_id, -0.05)

        per_worker_base = float(base['scheduled_orders_per_worker'])
        per_worker_test = float(test['scheduled_orders_per_worker'])

        orders_per_worker_abs_diff = per_worker_test - per_worker_base
        orders_per_worker_rel_diff = (per_worker_test - per_worker_base) / per_worker_base

        with open(str(data.path), 'w') as output:
            result = {}
            result['orders_per_worker_abs'] = orders_per_worker_abs_diff
            result['orders_per_worker_rel'] = orders_per_worker_rel_diff
            output.write(json.dumps(result, ensure_ascii=False, encoding='utf-8'))

        data.ready()

        if orders_per_worker_rel_diff < min_diff:
            raise TaskFailure(
                'Orders per worker relative diff {} less than {}\nBase: {}\nTest: {}'.format(
                    orders_per_worker_rel_diff, min_diff, per_worker_base, per_worker_test
                )
            )
