from sandbox import sdk2
from sandbox.sandboxsdk import environments

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view
from sandbox.projects.ydo.resource_types import YdoDispatchTesterBinary, YdoDispatchTesterResult

import datetime


class YdoDispatchTesterTask(sdk2.Task):
    class Requirements(sdk2.Requirements):
        environments = [
            environments.PipEnvironment('yandex-yt'),
        ]
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(
        generate_view(
            dispatch_tester_executable=YdoDispatchTesterBinary,
            check_owner=True,
            with_environ=True,
        )
    ):
        dispatch_host = sdk2.parameters.String(
            "Dispatch host",
            required=True,
        )
        dispatch_port = sdk2.parameters.Integer(
            "Dispatch grpc port",
            required=True,
        )
        seed = sdk2.parameters.String("Tester seed", default='lil')
        specialization = sdk2.parameters.String(
            "Specialization id",
            required=True,
        )
        real_date = sdk2.parameters.String(
            "Real mode real date, yesterday by default",
        )
        extra_orders_rate = sdk2.parameters.Float("Real model extra orders rate", default=0.3)
        seed_count = sdk2.parameters.Integer("Tester seed count", default=5)

    def on_execute(self):
        env = self.Parameters.get_environ()
        env["YT_TOKEN"] = sdk2.Vault.data(self.owner, "yt-token")

        resource = YdoDispatchTesterResult(self, "dispatch metrics file", "dispatch_metrics.json")
        data = sdk2.ResourceData(resource)

        real_date = self.Parameters.real_date
        if not real_date:
            real_date = str(datetime.date.today() - datetime.timedelta(days=1))

        cmd = [
            self.Parameters.dispatch_tester_executable_path,
            '--dispatch_host',
            self.Parameters.dispatch_host,
            '--dispatch_port',
            str(self.Parameters.dispatch_port),
            '--logging_level',
            '45',
            '--seed',
            self.Parameters.seed,
            '--real_mode',
            '--real_date',
            real_date,
            '--specialization',
            self.Parameters.specialization,
            '--extra_orders_rate',
            str(self.Parameters.extra_orders_rate),
            '--seed_count',
            str(self.Parameters.seed_count),
            '--disable_router',
            '--metrics_out',
            'dispatch_metrics.json'
        ]
        execute_cmd(cmd, "YdoDispatchTesterTask", "YdoDispatchTesterTask failed", env=env)

        data.ready()
