# -*- coding: utf-8 -*-

from collections import OrderedDict

from sandbox import sdk2
import sandbox.common.types.task as ctt
from sandbox.projects.ydo.indexer.YdoRunYQL2 import YdoRunYQL2
from sandbox.projects.ydo.dispatch.UpdateYdoOrdersPrediction import UpdateYdoOrdersPrediction


def extract_parameters(task_cls):
    for name in task_cls.Parameters.__custom_parameters_names__:
        parameter = getattr(task_cls.Parameters, name)
        yield name, parameter()


def get_parameters_dict(build_task):
        parameters_dict = OrderedDict()

        for name, parameter in extract_parameters(build_task):
            parameters_dict[name] = parameter
        return parameters_dict


def make_parameters_cls(parameters_dict):
    data = {}
    names = []

    for name, parameter in parameters_dict.iteritems():
        data[name] = parameter
        names.append(name)

    data['__names__'] = names
    return type('Parameters', (sdk2.Task.Parameters,), data)


def select_parameters(parameters):
    return [
        {
            'name': name,
            'param': param
        }
        for name, param in parameters
    ]


class YdoOrdersHistory(sdk2.Task):
    class Parameters(sdk2.Parameters):
        kill_timeout = 86400
        extra = make_parameters_cls(get_parameters_dict(YdoRunYQL2))

    def on_execute(self):
        self.build_task = YdoRunYQL2
        self.params = select_parameters(extract_parameters(self.build_task))
        priority = ctt.Priority(ctt.Priority.Class.SERVICE, ctt.Priority.Subclass.NORMAL)
        with self.memoize_stage.run_yql:
            subtask = self.build_task(self, priority=priority, kill_timeout=self.Parameters.kill_timeout)
            for source in self.params:
                value = getattr(self.Parameters, source['name'])
                setattr(subtask.Parameters, source['name'], value)
            subtask.save()
            subtask.enqueue()
            self.Context.subtask_id = subtask.id
            self.Context.save()
            raise sdk2.WaitTask(subtask, ctt.Status.Group.FINISH | ctt.Status.Group.BREAK)


class YdoOrdersPredictionPipeline(sdk2.Task):
    """Task that runs tasks for orders prediction"""

    class Parameters(sdk2.Parameters):
        kill_timeout = 86400
        extra = make_parameters_cls(get_parameters_dict(YdoOrdersHistory))
        extra2 = make_parameters_cls(get_parameters_dict(UpdateYdoOrdersPrediction))

    def on_execute(self):
        self.prepare = YdoOrdersHistory
        self.runner = UpdateYdoOrdersPrediction
        self.prepare_params = select_parameters(extract_parameters(self.prepare))
        self.runner_params = select_parameters(extract_parameters(self.runner))
        with self.memoize_stage.prepare:
            prepare_subtask = self.prepare(self)
            for source in self.prepare_params:
                value = getattr(self.Parameters, source['name'])
                setattr(prepare_subtask.Parameters, source['name'], value)
            prepare_subtask.save()
            prepare_subtask.enqueue()
            raise sdk2.WaitTask(prepare_subtask, ctt.Status.Group.FINISH | ctt.Status.Group.BREAK)

        with self.memoize_stage.runner:
            calc_subtask = self.runner(
                self,
                owner=self.owner,
            )
            for source in self.runner_params:
                value = getattr(self.Parameters, source['name'])
                setattr(calc_subtask.Parameters, source['name'], value)
            calc_subtask.save()
            calc_subtask.enqueue()
            raise sdk2.WaitTask(calc_subtask, ctt.Status.Group.FINISH | ctt.Status.Group.BREAK)
