from sandbox import sdk2
from sandbox.sandboxsdk import environments

from sandbox.projects.common.geosearch.utils import unpack_file
from sandbox.projects.geobase.Geodata6BinStable.resource import GEODATA6BIN_STABLE
from sandbox.projects.resource_types import GEODATATZDATA_STABLE

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view, ResourceWrapper
from sandbox.projects.ydo.resource_types import YdoDispatchMapsExecutable, YdoDispatchMapsDirectory


class YdoDispatchMapsTask(sdk2.Task):
    class Requirements(sdk2.Requirements):
        environments = [
            environments.PipEnvironment('yandex-yt'),
        ]
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(
        generate_view(
            dispatch_maps_executable=YdoDispatchMapsExecutable,
            geobase_snapshot=ResourceWrapper(GEODATA6BIN_STABLE),
            geodata_tz_snapshot=ResourceWrapper(GEODATATZDATA_STABLE),
            check_owner=True,
            with_environ=True,
        )
    ):
        squeeze_table = sdk2.parameters.String("Path to table with info about worker tracks", required=True)
        date_from = sdk2.parameters.String("Date from, YYYY-DD-MM")
        date_to = sdk2.parameters.String("Date to, YYYY-DD-MM")

    def on_execute(self):
        env = self.Parameters.get_environ()
        env["YT_TOKEN"] = sdk2.Vault.data(self.owner, "yt-token")

        unpack_file(self.Parameters.geodata_tz_snapshot_path, str(sdk2.Path.cwd()))

        resource = YdoDispatchMapsDirectory(self, "maps directory", "maps")
        data = sdk2.ResourceData(resource)

        cmd = [
            self.Parameters.dispatch_maps_executable_path,
            '--squeeze_table',
            self.Parameters.squeeze_table,
            '--geobase_file',
            self.Parameters.geobase_snapshot_path,
            '--tz_data',
            str(sdk2.Path.cwd().joinpath('zones_bin')),
        ]
        if self.Parameters.date_from:
            cmd.extend(['--date_from', self.Parameters.date_from])
        if self.Parameters.date_to:
            cmd.extend(['--date_to', self.Parameters.date_to])

        execute_cmd(cmd, "YdoDispatchMaps", "YdoDispatchMaps failed", env=env)

        data.ready()
