from sandbox import sdk2
from sandbox.sandboxsdk import environments

from sandbox.projects.geobase.Geodata6BinStable.resource import GEODATA6BIN_STABLE

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view, ResourceWrapper
from sandbox.projects.ydo.resource_types import (
    YdoDispatchOrderLossMapExecutable,
    YdoDispatchOrderLossMapDirectory,
    YdoDispatchConfig,
)

import datetime


class YdoOrderLossMapsTask(sdk2.Task):
    class Requirements(sdk2.Requirements):
        environments = [
            environments.PipEnvironment('yandex-yt'),
        ]
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(
        generate_view(
            order_loss_maps_executable=YdoDispatchOrderLossMapExecutable,
            geobase_snapshot=ResourceWrapper(GEODATA6BIN_STABLE),
            dispatch_config=YdoDispatchConfig,
            check_owner=True,
            with_environ=True,
        )
    ):
        squeeze_path = sdk2.parameters.String(
            "Path to directory with order loss squeeze",
            required=True,
            default='//home/ydo/dispatch/squeeze/order_loss',
        )
        end_date = sdk2.parameters.String(
            "Last squeeze table",
        )
        days_num = sdk2.parameters.Integer("Number of days to calc", default=1)

    def on_execute(self):
        env = self.Parameters.get_environ()
        env["YT_TOKEN"] = sdk2.Vault.data(self.owner, "yt-token")

        resource = YdoDispatchOrderLossMapDirectory(self, "maps directory", "maps")
        data = sdk2.ResourceData(resource)

        end_date = self.Parameters.end_date
        if not end_date:
            end_date = str(datetime.date.today() - datetime.timedelta(days=1))

        cmd = [
            self.Parameters.order_loss_maps_executable_path,
            '--squeeze-path',
            self.Parameters.squeeze_path,
            '--end-date',
            end_date,
            '--geobase-file',
            self.Parameters.geobase_snapshot_path,
            '--config',
            self.Parameters.dispatch_config_path,
            '--days-num',
            str(self.Parameters.days_num),
            '--output-path',
            'maps',
        ]
        execute_cmd(cmd, "YdoOrderLossMaps", "YdoOrderLossMaps failed", env=env)

        data.ready()
