# -*- coding: utf-8 -*-

from sandbox import sdk2

from sandbox.projects.ydo.resource_types import ydo_releasers  # noqa


class YdoDjCompiledConfigs(sdk2.Resource):
    """
    DJ compiled configs for Ydo
    """

    any_arch = True
    releasable = True
    releasers = ydo_releasers


class YdoDjShards(sdk2.Resource):
    """
    DJ shards for Ydo
    """

    any_arch = True
    releasable = True
    releasers = ydo_releasers
    shard = True


class YdoDjModels(sdk2.Resource):
    """
    DJ models for Ydo
    """

    any_arch = True
    releasable = True
    releasers = ydo_releasers


class YdoDjShard2ResourceBundle(sdk2.Resource):
    """
    Directory with recommender/shard_builder configs and models
    """
    any_arch = True
    executable = False
    releasable = True
    releasers = ydo_releasers


class YdoDjFreshProfileServerExecutable(sdk2.Resource):
    """
    DJ FPS server
    """
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoDjRecommenderExecutable(sdk2.Resource):
    """
    DJ recommender
    """
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoDjServiceShard(sdk2.Resource):
    """
    DJ shard for Ydo service recs
    """

    any_arch = True
    releasable = True
    releasers = ydo_releasers
