import sandbox.projects.ydo.process_generator as process_generator


class TaskMixin(process_generator.BaseMixin):
    def get_cmd(self):
        return [
            self.get_binary_path(),
            '--config',
            self.get_config_path(),
        ]


class ProcessGenerator(process_generator.ProcessGenerator):
    TaskMixinClass = TaskMixin


pg = ProcessGenerator(
    'ydo/erp/tools/employees/calculate_employees_working_status/bin',
    binary_name='calculate_employees_working_status',
    config_spec=process_generator.ConfigSpec(
        'ydo/erp/tools/employees/calculate_employees_working_status/configs',
        [
            ('production', 'production.yaml'),
        ],
    ),
    use_yav_secrets=False
)


class YdoCalculateEmployeesWorkingStatusExecutable(pg.generate_resource()):
    pass


class BuildYdoCalculateEmployeesWorkingStatusExecutable(pg.generate_build_task(YdoCalculateEmployeesWorkingStatusExecutable)):
    pass


class YdoCalculateEmployeesWorkingStatus(pg.generata_task(YdoCalculateEmployeesWorkingStatusExecutable)):
    pass
