# -*- coding: utf-8 -*-
from sandbox import sdk2, common
import sandbox.common.types.task as ctt

from sandbox.projects.common.geosearch.base_update import generate_base_update_task_sdk2
from sandbox.projects.ydo.erp.YdoErpServicesSchemasMerger import YdoErpServicesSchemasMerger
from sandbox.projects.ydo.solomon_mixin import SolomonMixinV2


BaseUpdate = generate_base_update_task_sdk2(YdoErpServicesSchemasMerger, release_subject="Update YdoErpServicesSchemasMerger", force_rebuild=True)


class UpdateYdoErpServicesSchemasMerger(BaseUpdate, SolomonMixinV2):
    """
        Update YdoErpServicesSchemasMerger
    """

    class Requirements(BaseUpdate.Requirements):
        cores = 1

        class Caches(BaseUpdate.Requirements.Caches):
            pass

    def end_indexing(self):
        subtask = sdk2.Task[self.Context.subtask_id]

        if subtask.status != ctt.Status.SUCCESS:
            raise common.errors.TaskFailure('Child task {} failed'.format(subtask))

        if self.Parameters.release_type and subtask.Context.can_auto_release:
            self.server.release(
                task_id=subtask.id,
                type=self.Parameters.release_type,
                subject=self.release_subject,
                comments=self.release_comments,
            )

    def on_finish(self, prev_status, status):
        SolomonMixinV2.on_finish(self, prev_status, status)
        super(UpdateYdoErpServicesSchemasMerger, self).on_finish(prev_status, status)
