import json

from sandbox import sdk2
from sandbox.projects.ydo import ydo_releasers

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view
from sandbox.projects.ydo.solomon_mixin import SolomonMixinV2


class YdoExternalWorkersScheduleConfirmationsExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoExternalWorkersScheduleConfirmations(sdk2.Task, SolomonMixinV2):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(
        generate_view(
            ydo_external_workers_schedule_confirmations=YdoExternalWorkersScheduleConfirmationsExecutable,
            check_owner=True,
            with_environ=True,
        )
    ):
        with sdk2.parameters.Group('KIKIMR_CONNECTION'):
            ydb_host = sdk2.parameters.String('Host', required=True)
            ydb_home = sdk2.parameters.String('Home', required=True)
            ydb_database = sdk2.parameters.String('Database', required=True)
            ydb_port = sdk2.parameters.Integer('Port', default=2135)
            ydb_retry_count = sdk2.parameters.Integer('RetryCount', default=5)
            ydb_delay = sdk2.parameters.Integer('Delay', default=4)
            ydb_backoff = sdk2.parameters.Integer('Backoff', default=2)
            ydb_limit = sdk2.parameters.Integer('Limit', default=15)
        with sdk2.parameters.Group('YT_TABLES'):
            yt_external_workers = sdk2.parameters.String('YT external_workers path', required=True)
            yt_orders_aux = sdk2.parameters.String('YT orders_aux path', required=True)
            yt_order_partners = sdk2.parameters.String('YT order_partners path', required=False)
            yt_order_events_history = sdk2.parameters.String('YT order_events_history path', required=False)
            yt_erp_employees = sdk2.parameters.String('YT erp_employees path', required=False)
            yt_erp_calendars_dir = sdk2.parameters.String('YT erp_calendars directory path', required=False)

        window_size = sdk2.parameters.Integer('Window size', default=60)
        logging_config = sdk2.parameters.String('LoggingConfig')

    def add_param_to_cmd(self, cmd, name, parameter, exclude=None):
        if parameter and parameter not in (exclude or []):
            cmd += [name, parameter]

    def on_execute(self):
        cmd = [
            self.Parameters.ydo_external_workers_schedule_confirmations_path,
            '--kikimr-host',
            self.Parameters.ydb_host,
            '--kikimr-home',
            self.Parameters.ydb_home,
            '--kikimr-database',
            self.Parameters.ydb_database,
            '--kikimr-port',
            str(self.Parameters.ydb_port),
            '--external_workers',
            self.Parameters.yt_external_workers,
            '--orders_aux',
            self.Parameters.yt_orders_aux,
            '--order_partners',
            self.Parameters.yt_order_partners,
            '--order_events_history',
            self.Parameters.yt_order_events_history,
            '--erp_employees',
            self.Parameters.yt_erp_employees,
            '--erp_calendars_dir',
            self.Parameters.yt_erp_calendars_dir,
            '--window_size',
            str(self.Parameters.window_size),
        ]

        self.add_param_to_cmd(cmd, '--logging-config', self.Parameters.logging_config)
        self.add_param_to_cmd(cmd, '--kikimr-retry-count', str(self.Parameters.ydb_retry_count))
        self.add_param_to_cmd(cmd, '--kikimr-delay', str(self.Parameters.ydb_delay))
        self.add_param_to_cmd(cmd, '--kikimr-backoff', str(self.Parameters.ydb_backoff))
        self.add_param_to_cmd(cmd, '--kikimr-limit', str(self.Parameters.ydb_limit))

        execute_cmd(
            cmd,
            'ydo_external_workers_schedule_confirmations',
            'ydo_external_workers_schedule_confirmations failed',
            env=self.Parameters.get_environ(),
        )

    def on_break(self, *args, **kwargs):
        SolomonMixinV2.on_break(self, *args, **kwargs)
        super(YdoExternalWorkersScheduleConfirmations, self).on_break(*args, **kwargs)

    def on_finish(self, *args, **kwargs):
        SolomonMixinV2.on_finish(self, *args, **kwargs)
        super(YdoExternalWorkersScheduleConfirmations, self).on_finish(*args, **kwargs)
