from sandbox import sdk2
from sandbox.projects.ydo import execute_cmd, ydo_releasers
from sandbox.projects.ydo.parameters_view import generate_view


# Resource types
class YdoFindGDPRUserDataExecutable(sdk2.Resource):
    """
    Find GDPR User Data
    """

    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoFindGDPRUserData(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(
        generate_view(
            find_gdpr_user_data_executable=YdoFindGDPRUserDataExecutable,
            check_owner=True,
            with_environ=True,
            default_secret_env_vars={
                'YDB_TOKEN': 'ydb-token',
                'YT_TOKEN': 'yt-token',
                'YQL_TOKEN': 'YQL_TOKEN',
            },
        )
    ):
        with sdk2.parameters.Group('Kikimr parameters') as kikimr_block:
            ydb_host = sdk2.parameters.String('YDB host', required=True)
            ydb_port = sdk2.parameters.Integer('YDB port', required=True)
            ydb_database = sdk2.parameters.String('YDB database', required=True)
            ydb_home = sdk2.parameters.String('YDB home', required=True)
            ydb_push_batch_size = sdk2.parameters.Integer(
                'Number of objects to update in one transaction', required=True, default=200
            )

        new_data_buffer_size = sdk2.parameters.Integer(
            'Buffer size for new data to store in memory', required=True, default=10000
        )
        yt_backups_path = sdk2.parameters.String('Path to backups in YT.', required=True)
        yt_cluster = sdk2.parameters.String('YT cluster', required=True, default='hahn')

    def on_execute(self):
        cmd = [
            self.Parameters.find_gdpr_user_data_executable_path,
            'cli',
            '--ydb_host',
            self.Parameters.ydb_host,
            '--ydb_port',
            str(self.Parameters.ydb_port),
            '--ydb_database',
            self.Parameters.ydb_database,
            '--ydb_home',
            self.Parameters.ydb_home,
            '--ydb_push_batch_size',
            str(self.Parameters.ydb_push_batch_size),
            '--new_data_buffer_size',
            str(self.Parameters.new_data_buffer_size),
            '--yt_backups_path',
            self.Parameters.yt_backups_path,
            '--yt_cluster',
            self.Parameters.yt_cluster,
            '--yql_cluster',
            self.Parameters.yt_cluster,
            '--raise_on_errors',
        ]

        execute_cmd(cmd, 'ydo_find_gdpr_user_data', 'Search failed', env=self.Parameters.get_environ())
