import logging
import os

from sandbox import sdk2
from sandbox.common.types import misc as ctm
from sandbox.projects.ydo import execute_cmd, ydo_releasers
from sandbox.projects.ydo.parameters_view import generate_view
from sandbox.sandboxsdk.environments import PipEnvironment


class YdoGetPaymentBatchesHandler(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers
    arcadia_build_path = "ydo/tools/balance/get_payment_batches/bin"
    executable = True

    binary_path = sdk2.parameters.String(default='get_payment_batches')


class YdoGetPaymentBatches(sdk2.Task):
    """Task that downloads payment batches"""

    class Parameters(generate_view(
        processor=YdoGetPaymentBatchesHandler,
        check_owner=True,
    )):
        tokens = sdk2.parameters.YavSecret("YAV YDO_OAUTH_TOKENS secret id", required=True)
        ydo_secrets = sdk2.parameters.YavSecret("YAV YDO_SECRETS secret id", required=True)

        ydb_host = sdk2.parameters.String('YDB Host', required=True)
        ydb_port = sdk2.parameters.Integer('YDB Port', default=2135, required=True)
        ydb_database = sdk2.parameters.String('YDB Database', required=True)
        ydb_home = sdk2.parameters.String('YDB Home', required=True)

        environment = sdk2.parameters.String('Environment', required=True, default='test')

    class Requirements(sdk2.Requirements):
        cores = 1
        dns = ctm.DnsType.DNS64
        environments = (
            PipEnvironment('requests'),
        )

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        logging.info('Starting executing get_payment_batches')

        env = os.environ.copy()
        env['YDB_TOKEN'] = self.Parameters.tokens.data()['YDB_TOKEN']
        env['TVM_SECRET'] = self.Parameters.ydo_secrets.data()['TVM_SECRET']

        execute_cmd(
            [
                str(self.Parameters.processor_path),
                '--ydb_host', str(self.Parameters.ydb_host),
                '--ydb_port', str(self.Parameters.ydb_port),
                '--ydb_database', str(self.Parameters.ydb_database),
                '--ydb_home', str(self.Parameters.ydb_home),
                '--environment', str(self.Parameters.environment),
            ],
            'get_payment_batches',
            'Failed to get_payment_batches',
            env=env,
        )

        logging.info('Done')
