import sandbox.projects.ydo.process_generator as process_generator


class TaskMixin(process_generator.BaseMixin):
    def get_cmd(self):
        return [
            self.get_binary_path(),
            '--config',
            self.get_config_path(),
        ]


class ProcessGenerator(process_generator.ProcessGenerator):
    TaskMixinClass = TaskMixin


pg = ProcessGenerator(
    build_binary_path='ydo/tools/partner_flow/granted_income_for_external_workers_processor/bin',
    binary_name='granted_income_for_external_workers_processor',
    config_spec=process_generator.ConfigSpec(
        'ydo/tools/partner_flow/granted_income_for_external_workers_processor/configs',
        [
            ('production', 'production.yaml'),
            ('testing', 'testing.yaml'),
        ],
    ),
    use_yav_secrets=False,
)


class YdoGrantedIncomeForExternalWorkersProcessorExecutable(pg.generate_resource()):
    pass


class BuildYdoGrantedIncomeForExternalWorkersProcessorExecutable(pg.generate_build_task(YdoGrantedIncomeForExternalWorkersProcessorExecutable)):
    pass


class YdoGrantedIncomeForExternalWorkersProcessor(pg.generata_task(YdoGrantedIncomeForExternalWorkersProcessorExecutable)):
    pass
