import datetime

from sandbox import sdk2

from sandbox.projects.ydo import execute_cmd, YdoFeaturesJson
from sandbox.projects.ydo import ydo_releasers
from sandbox.projects.ydo.parameters_view import generate_view, with_config
from sandbox.projects.ydo.rubrics_merger.YdoRubricsMerger import YdoMergedRubricsDump


class YdoHangingOrdersHandlerExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoHangingOrdersHandler(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(generate_view(ydo_hanging_orders_handler=YdoHangingOrdersHandlerExecutable, check_owner=True, with_environ=True)):
        with sdk2.parameters.Group('KIKIMR_CONNECTION'):
            ydb_host = sdk2.parameters.String('Host', required=True)
            ydb_home = sdk2.parameters.String('Home', required=True)
            ydb_database = sdk2.parameters.String('Database', required=True)
            ydb_port = sdk2.parameters.Integer('Port', default=2135)
            ydb_retry_count = sdk2.parameters.Integer('RetryCount', default=5)
            ydb_delay = sdk2.parameters.Integer('Delay', default=4)
            ydb_backoff = sdk2.parameters.Integer('Backoff', default=2)
            ydb_limit = sdk2.parameters.Integer('Limit', default=15)
        with sdk2.parameters.Group('SAMSARA_CONNECTION'):
            samsara_host = sdk2.parameters.String('Samsara host', required=True)
        with sdk2.parameters.Group('YANG_CONNECTION'):
            yang_host = sdk2.parameters.String('Yang host', required=True)
        with sdk2.parameters.Group('YT_CONNECTION'):
            yt_path = sdk2.parameters.String('Yt path', required=True)
        queue_ids = sdk2.parameters.String('Queue ids', required=True)
        close_tickets_after_days_number = sdk2.parameters.String('Number of days after which to close ticket (only for testing)', required=True)
        saas_host = sdk2.parameters.String('Saas host', required=True)
        logging_config = sdk2.parameters.String('LoggingConfig')


    def add_param_to_cmd(self, cmd, name, parameter):
        if parameter:
            cmd += [name, parameter]

    def on_execute(self):
        rubrics_json_prod = get_last_resource(YdoMergedRubricsDump, 'stable')
        features_json_prod = get_last_resource(YdoFeaturesJson, 'stable')

        cmd = [
            self.Parameters.ydo_hanging_orders_handler_path,
            '--kikimr_host', self.Parameters.ydb_host,
            '--kikimr_home', self.Parameters.ydb_home,
            '--kikimr_database', self.Parameters.ydb_database,
            '--kikimr_port', str(self.Parameters.ydb_port),

            '--samsara_host', self.Parameters.samsara_host,
            '--yang_host', self.Parameters.yang_host,
            '--close_tickets_after_days_number', self.Parameters.close_tickets_after_days_number,
            '--queue_ids', self.Parameters.queue_ids,

            '--rubrics_json', str(sdk2.ResourceData(rubrics_json_prod).path),
            '--features_json', str(sdk2.ResourceData(features_json_prod).path),
            
            '--saas_host', self.Parameters.saas_host,
        ]

        self.add_param_to_cmd(cmd, '--logging-config', self.Parameters.logging_config)
        self.add_param_to_cmd(cmd, '--kikimr_retry_count', str(self.Parameters.ydb_retry_count))
        self.add_param_to_cmd(cmd, '--kikimr_delay', str(self.Parameters.ydb_delay))
        self.add_param_to_cmd(cmd, '--kikimr_backoff', str(self.Parameters.ydb_backoff))
        self.add_param_to_cmd(cmd, '--kikimr_limit', str(self.Parameters.ydb_limit))

        execute_cmd(cmd, 'ydo_hanging_orders_handler', 'ydo_hanging_orders_handler failed', env=self.Parameters.get_environ())


def get_last_resource(resource_type, release_status):
    last_resource = resource_type.find(attrs=dict(released=release_status)).first()
    if last_resource is not None:
        return last_resource
    return None
