import os
import datetime

from sandbox import sdk2
from sandbox.projects.ydo import ydo_releasers

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view


class YdoHitmanMonitoringsExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoHitmanMonitorings(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(generate_view(ydo_hitman_monitorings=YdoHitmanMonitoringsExecutable, check_owner=True, with_environ=True)):
        with sdk2.parameters.Group('HITMAN'):
            hitman_host = sdk2.parameters.String('Hitman host', required=True)
        with sdk2.parameters.Group('SANDBOX'):
            sandbox_host = sdk2.parameters.String('Sandbox host', required=True)

        scheduler_id = sdk2.parameters.String('Monitoring scheduler id', required=True)
        logging_config = sdk2.parameters.String('LoggingConfig')

    def add_param_to_cmd(self, cmd, name, parameter):
        if parameter:
            cmd += [name, parameter]

    def on_execute(self):
        cmd = [
            self.Parameters.ydo_hitman_monitorings_path,
            '--hitman_host', self.Parameters.hitman_host,
            '--sandbox_host', self.Parameters.sandbox_host,
            '--scheduler_id', self.Parameters.scheduler_id,
        ]

        self.add_param_to_cmd(cmd, '--logging-config', self.Parameters.logging_config)

        execute_cmd(cmd, 'ydo_hitman_monitorings', 'ydo_hitman_monitorings failed', env=self.Parameters.get_environ())
