pragma yson.DisableStrict;

$conventional_extractor = ($node) -> {
    return Yson::ConvertToUint64(Yson::YPath($node, "/geoid"));
};

$docdoc_extractor = ($node) -> {
    return Yson::ConvertToUint64(ListHead(Yson::ConvertToList(Yson::YPath($node, "/geoids"))));
};

$extract_geoids = ($mylist, $extractor) -> {
    return ListFlatMap($mylist,
                ($x) -> {return cast($extractor($x) as Int32)});
};

$extract_list = ($column, $field) -> {
    return Yson::ConvertToList(Yson::YPath(Yson::Parse($column), $field));
};

$concat_all_geoid = ($extractor, $personal_info, $main_address) -> {
    return ListExtend($extract_geoids($extract_list($personal_info, "/addressesList"), $extractor),
                      $extract_geoids($extract_list($personal_info, "/areasList"), $extractor),
                      $extract_geoids(AsList(Yson::Parse($main_address)), $extractor));
};

$process_geoids = ($geoids) -> {
    $russian_geoids = ListFilter($geoids, ($x) -> {return Geo::RoundRegionById($x, 'country').id = 225});
    return ListUniq(ListFlatMap($russian_geoids, ($x) ->
        {return if(Geo::RoundRegionById($x, 'region').capital_id = $x, AsList(10000, $x, Geo::RoundRegionById($x, 'region').id), AsList(10000, Geo::RoundRegionById($x, 'region').id))}))
};

$get_geoids = ($personal_info, $main_address) -> {
    return $process_geoids($concat_all_geoid($conventional_extractor, $personal_info, $main_address));
};

$get_docdoc_geoids = ($personal_info, $main_address) -> {
    return $process_geoids($concat_all_geoid($docdoc_extractor, $personal_info, $main_address));
};

EXPORT $get_geoids;
EXPORT $get_docdoc_geoids;