USE hahn;

pragma AnsiInForEmptyOrNullableItemsCollections;

$rubric_blacklist = assetstrict(
    "10012252304"
);

$get_permalink = ($answer) -> {
    return Yson::YPathString(Yson::Parse($answer), "/data/answer_short_text_545077/value", Yson::Options(false as Strict));
};

DEFINE SUBQUERY $permalink_blacklist($path) AS
    select
        cast(company_permalink as int64) as company_permalink
    FROM (
        SELECT $get_permalink(answer) as company_permalink
        FROM $path
    )
    WHERE company_permalink is not null;
END DEFINE;

$permalink_blacklist_static = asliststrict(
    1134839896l,
    45675683323l,
    45023261635l,
    215441118835l,
    225528132099l,
    217596676564l,
    226092408054l,
    10625945257l,
    45675683323l,
    45023261635l,
    215441118835l,
    225528132099l,
    217596676564l,
    156134109079l,
    28620998834l,
    129749618602l,
    215194076981l,
    107858480731l,
    212515134169l,
    43413848830l,
    178594877276l,
    192811590044l,
    1782755840l,
    1724499868l,
    99775033234l,
    49428629026l,
    179723529732l,
    33482255931l
);

$chain_permalink_blacklist_static = asliststrict(
    675976769l, -- Почта России
);

DEFINE SUBQUERY $map($path) AS
    select
        altay_id,
        uslugi_id
    from $path
END DEFINE;

DEFINE SUBQUERY $orgs_blacklist($path) AS
    select
        company_permalink
    from `//home/sprav/altay/prod/snapshot/company_to_rubric`
    where
        rubric_permalink in $rubric_blacklist
    union all
    select
        company_permalink
    from as_table(ListMap($permalink_blacklist_static, ($i) -> { return <|company_permalink: $i|>}))
    union all
    select
        company_permalink
    from
        $permalink_blacklist($path)
    union all
    select
        company_permalink
    from
        as_table(ListMap($chain_permalink_blacklist_static, ($i) -> { return <|chain_permalink: $i|>})) as a
        inner join
        `//home/sprav/altay/prod/snapshot/company_to_chain` as b
        using (chain_permalink);
END DEFINE;

DEFINE SUBQUERY $orgs_raw($mapping_path) AS
    select
        a.company_permalink as company_permalink,
        AGGREGATE_LIST(m.uslugi_id) as uslugi_category
    from
        `//home/sprav/altay/prod/snapshot/company_to_rubric` as a
        inner join
        $map($mapping_path) as m
        on m.altay_id == a.rubric_permalink
    group by a.company_permalink;
END DEFINE;

DEFINE SUBQUERY $orgs($blacklist_path, $mapping_path) AS
    select
        o.company_permalink as company_permalink,
        o.uslugi_category as uslugi_category
    from
        $orgs_raw($mapping_path) as o
        left only join
        $orgs_blacklist($blacklist_path) as b
    on o.company_permalink == b.company_permalink;
END DEFINE;

DEFINE SUBQUERY $chains() AS
    select
        company_permalink,
        permalink as chain_permalink,
        names as chain_names
    from
        `//home/sprav/altay/prod/snapshot/chain` as a
        inner join
        `//home/sprav/altay/prod/snapshot/company_to_chain` as b
        on a.id == b.chain_id;
END DEFINE;

DEFINE SUBQUERY $orgs_with_chains($blacklist_path, $mapping_path) AS
    select
        a.uslugi_category as uslugi_category,
        a.company_permalink as company_permalink,
        b.chain_permalink as chain_permalink,
        b.chain_names as chain_names
    from
        $orgs($blacklist_path, $mapping_path) as a
        left join
        $chains() as b
        on a.company_permalink == b.company_permalink;
END DEFINE;

$get_url = ($x) -> {
    return "https://avatars.mds.yandex.net/get-altay/" || cast($x.group as string) || "/" || $x.name;
};

DEFINE SUBQUERY $convert_altay($blacklist_path, $mapping_path) AS
select
    altay.permalink as permalink,
    Yson::SerializePretty(Yson::From(asstruct(
        "org" as account_type,
        False as email_agreement,
        False as phone_agreement,
        ListNotNull(ListMap(altay.export_proto.Name, ($n) -> { return if($n.Lang == "RU", $n.Value) }))[0] as company_name,
        ListNotNull(ListMap(altay.export_proto.Link, ($n) -> { return if($n.Aref == "vkontakte", $n.Href) }))[0] as vk,
        String::SplitToList(ListNotNull(ListMap(altay.source_proto.urls, ($url) -> { return if($url.value like '%yclients.com/?ap%', $url.value) }))[0], '?')[0] as yclients,
        altay.export_proto.Url[0] as site,
        cast(String::SplitToList(altay.export_proto.WorkingTime[0].From, ":")[0] as uint32) + 1 as `contact-start-time`,
        cast(String::SplitToList(altay.export_proto.WorkingTime[0].To, ":")[0] as uint32) + 1 as `contact-finish-time`,
        altay.export_proto.Phone[0].Formatted as `org-phone`,
        altay.export_proto.Phone[0].Formatted as phone,
        asstruct(
            ListNotNull(ListMap(altay.export_proto.Geo.Address.Formatted, ($n) -> { return if($n.Lang == "RU", $n.Value) }))[0] as address,
            altay.export_proto.Geo.Location.GeoId as cityId,
            Geo::RegionById(cast(altay.export_proto.Geo.Location.GeoId as int32)).name as cityName,
            altay.export_proto.Geo.Location.Pos as geometry
        ) as address,
        altay.source_proto.is_online as `_is_online_org`,
    ))) as personal_info,
    altay.feature_values as features,
    altay.rubrics as rubrics,
    altay.names as company_names,
    altay.rating as rating,
    Yson::GetLength(altay.reviews) as review_count,
    $get_url(ListNotNull(ListMap(altay.source_proto.photos, ($n) -> {
        return if($n.status == "Publish" and $n.order == 1 and not ListHas($n.tags , "Panorama"), $n.value)
    }))[0]) as photo,
    org.uslugi_category as uslugi_category,
    org.chain_permalink as chain_permalink,
    org.chain_names as chain_names
from
    $orgs_with_chains($blacklist_path, $mapping_path) as org
    join
    `//home/sprav/altay/prod/snapshot/company` as altay
    on org.company_permalink == altay.permalink
where
    publishing_status == "publish"
    and Geo::RoundRegionById(cast(altay.export_proto.Geo.Location.GeoId as int32), "country").id == 225;
END DEFINE;

EXPORT $convert_altay;
