import os
import socket

from sandbox import sdk2
from sandbox.sandboxsdk import environments
from sandbox.projects.ydo import (
    execute_cmd,
    ydo_releasers,
)
from sandbox.projects.ydo.resource_types import YdoSearchAsyncApiWorkerConfigs


class YdoSendBatchToRtIndexerExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoSendBatchToRtIndexer(sdk2.Task):
    class Requirements(sdk2.Requirements):
        environments = [
            environments.PipEnvironment('yandex-yt'),
        ]
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):

        send_batch_to_rt_indexer_executable_resource = sdk2.parameters.Resource(
            "send_batch_to_rt_indexer",
            resource_type=YdoSendBatchToRtIndexerExecutable,
            required=True,
        )
        batch_size = sdk2.parameters.Integer(
            "batch size for send batch",
            required=True,
            default=100,
        )
        with sdk2.parameters.RadioGroup('rt-indexer ctype') as ctype:
            ctype.values["testing"] = ctype.Value("testing")
            ctype.values["production"] = ctype.Value("production")
        async_api_pipe_config_template = sdk2.parameters.Resource(
            "search async api worker templates",
            resource_type=YdoSearchAsyncApiWorkerConfigs,
            required=True,
        )
        workers_table = sdk2.parameters.String("workers table from backup", required=True)
        tokens = sdk2.parameters.YavSecret(
            "ydo oauth tokens in yav",
            required=True,
            description="Secret should contain keys: LOGBROKER_TOKEN, YT_TOKEN, YDB_TOKEN",
        )
        reqid = sdk2.parameters.String("reqid for debug", required=True)

    def on_execute(self):
        hostname = socket.gethostname()
        async_api_pipe_template_path = os.path.join(str(sdk2.ResourceData(self.Parameters.async_api_pipe_config_template).path), self.Parameters.ctype, "async_api_pipe_template.yaml")
        async_api_pipe_config_path = "async_api_pipe_config.yaml"
        with open(async_api_pipe_template_path) as fin, open(async_api_pipe_config_path, "w") as fout:
            async_api_pipe_config = fin.read()
            fout.write(async_api_pipe_config.replace("{{ HOSTNAME }}", hostname))

        env = os.environ.copy()
        env["LOGBROKER_TOKEN"] = self.Parameters.tokens.data()["LOGBROKER_TOKEN"]
        env["YT_TOKEN"] = self.Parameters.tokens.data()["YT_TOKEN"]
        env["YDB_TOKEN"] = self.Parameters.tokens.data()["YDB_TOKEN"]

        cmd = [
            str(sdk2.ResourceData(self.Parameters.send_batch_to_rt_indexer_executable_resource).path),
            "--async_api_config", async_api_pipe_config_path,
            "--workers_table", self.Parameters.workers_table,
            "--batch_size", str(self.Parameters.batch_size),
            "--reqid", self.Parameters.reqid,
        ]

        execute_cmd(cmd, "send_batch_to_rt_indexer", "send_batch_to_rt_indexer failed", env=env)
