from sandbox import sdk2
from sandbox.projects.ydo import (
    execute_cmd,
    ydo_releasers,
    YdoMainSitemap,
    YdoSmModelSitemap,
    YdoSpravSitemap,
)


class YdoSitemapMergerExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoSitemap(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoSitemapMerger(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        sitemap_bucket = sdk2.parameters.String("S3 bucket for sitemap", required=True)
        sitemap_merger_executable_resource = sdk2.parameters.Resource(
            "sitemap_merger",
            resource_type=YdoSitemapMergerExecutable,
            required=True,
        )
        main_sitemap = sdk2.parameters.Resource(
            "main_sitemap",
            resource_type=YdoMainSitemap,
        )
        sprav_sitemap = sdk2.parameters.Resource(
            "sprav_sitemap",
            resource_type=YdoSpravSitemap,
        )
        service_model_sitemap = sdk2.parameters.Resource(
            "service_model_sitemap",
            resource_type=YdoSmModelSitemap,
        )

    def on_execute(self):
        cmd = [
            str(sdk2.ResourceData(self.Parameters.sitemap_merger_executable_resource).path),
            "--s3_bucket_name", self.Parameters.sitemap_bucket,
            "--s3_access_key_id", sdk2.Vault.data(self.owner, "s3_ydo_key_id"),
            "--s3_secret_access_key", sdk2.Vault.data(self.owner, "s3_ydo_secret_key"),
        ]

        cmd += [
            "--sitemap_body",
        ]
        cmd += [str(sdk2.ResourceData(self.Parameters.main_sitemap).path)] if self.Parameters.main_sitemap else []
        cmd += [str(sdk2.ResourceData(self.Parameters.sprav_sitemap).path)] if self.Parameters.sprav_sitemap else []
        cmd += [str(sdk2.ResourceData(self.Parameters.service_model_sitemap).path)] if self.Parameters.service_model_sitemap else []

        sitemap_resource = sdk2.ResourceData(YdoSitemap(self, "Ydo sitemap", "sitemap.xml.gz"))
        execute_cmd(cmd, "sitemap_merger", "sitemap_merger failed")
        sitemap_resource.ready()
