from sandbox import sdk2

from sandbox.projects.ydo import get_last_released_resource, YdoKikimrExecutable


class YdoKikimrBaseTask(sdk2.Task):
    class Parameters(sdk2.Parameters):
        use_stable_ydo_kikimr = sdk2.parameters.Bool(
            "Use stable ydo kikimr?",
            default=True,
        )
        with use_stable_ydo_kikimr.value[False]:
            kikimr_executable_resource = sdk2.parameters.Resource(
                "Kikimr",
                resource_type=YdoKikimrExecutable,
                required=True,
            )

    def get_kikimr_resource_data(self):
        return get_last_released_resource(
            YdoKikimrExecutable,
            condition=self.Parameters.use_stable_ydo_kikimr,
            default=self.Parameters.kikimr_executable_resource,
            error_msg="YdoKikimrExecutable not found",
        )
