from sandbox import sdk2

from sandbox.projects.ydo import ydo_releasers

from sandbox.projects.ydo.parameters_view import generate_view
from sandbox.projects.ydo import execute_cmd


class YdoRegisterBusinessAccountsExecutable(sdk2.Resource):
    '''Tool for registering workers as business accounts'''
    releasable = True
    releasers = ydo_releasers


class YdoRegisterBusinessAccounts(sdk2.Task):
    class Parameters(generate_view(register_executable=YdoRegisterBusinessAccountsExecutable, check_owner=True, with_environ=True)):
        self_tvm_id = sdk2.parameters.Integer("Self TVM id", required=True)

        with sdk2.parameters.Group("YDB parameters") as ydb_block:
            ydb_host = sdk2.parameters.String("Host", required=True)
            ydb_database = sdk2.parameters.String("Database", required=True)
            ydb_home = sdk2.parameters.String("Home", required=True)

        backups_yt_path = sdk2.parameters.String('Path to backups', required=True)

        with sdk2.parameters.Group("Chats parameters") as chats_block:
            chats_host = sdk2.parameters.String("Host", required=True)
            chats_tvm_id = sdk2.parameters.Integer("Chats TVM id", required=True)
            provider = sdk2.parameters.String("Provider", required=True)

    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def register_workers(self):
        env = self.Parameters.get_environ()
        register_cmd = [
            self.Parameters.register_executable_path,
            '--ydb_host', self.Parameters.ydb_host,
            '--ydb_database', self.Parameters.ydb_database,
            '--ydb_home', self.Parameters.ydb_home,

            '--db_dump_dir', self.Parameters.backups_yt_path,
            '--dump_is_from_yt',

            '--tvm_secret', env['TVM_SECRET'],
            '--self_tvm_id', str(self.Parameters.self_tvm_id),
            '--chats_tvm_id', str(self.Parameters.chats_tvm_id),
            '--feedback_host', self.Parameters.chats_host,
            '--provider', self.Parameters.provider,

            '--logging_level', '10',
        ]
        execute_cmd(register_cmd, 'register', 'register failed', env=env)

    def on_execute(self):
        self.register_workers()
