import os
import logging

from sandbox import sdk2

from sandbox.projects.ydo.moderation import YdoModerationBaseTask


class YdoModerationAggregateImportFromSources(YdoModerationBaseTask):
    class Parameters(sdk2.Parameters):
        with sdk2.parameters.Group("YT parameters") as yt_block:
            yt_vault_token = sdk2.parameters.String("Your yt token name in vault", default="yt-token", required=True)
            with sdk2.parameters.RadioGroup("Host") as yt_host:
                yt_host.values["hahn"] = yt_host.Value(value="Hahn", default=True)
                yt_host.values["banach"] = yt_host.Value(value="Banach")
            yt_lock_node = sdk2.parameters.String("Lock path", required=True)
            yt_import_folder = sdk2.parameters.String("Folder", required=True)
            yt_sources_folder = sdk2.parameters.List("Source folders", value_type=sdk2.parameters.String, required=True)

    def get_yt_parameters(self):
        return sdk2.Vault.data(self.owner, self.Parameters.yt_vault_token), self.Parameters.yt_host

    def move_tables(self, yt_client, source_table):
        for table in list(yt_client.list(source_table)):
            move_table = os.path.join(source_table, table)
            import_table = os.path.join(self.Parameters.yt_import_folder, table + "_" + os.path.basename(source_table))
            logging.debug("move {} to {}".format(move_table, import_table))
            yt_client.move(move_table, import_table)

    def on_execute(self):
        import yt.wrapper as yt
        yt.config["token"], yt.config["proxy"]["url"] = self.get_yt_parameters()

        with yt.Transaction():
            yt.lock(self.Parameters.yt_lock_node, waitable=True)

            for source_table in self.Parameters.yt_sources_folder:
                self.move_tables(yt, source_table)
