from sandbox import sdk2

from sandbox.projects.ydo import execute_cmd, YdoFeaturesJson

from sandbox.projects.ydo.parameters_view import generate_view

from sandbox.projects.ydo.default_multislot_task import YdoMutlihostTask

from sandbox.projects.ydo.moderation import (
    wc_lines,
    YdoModerationUsersBatch,
    YdoModerationDataFile,
    YdoModerationCommitFile,
    YdoModerationOpsExecutable,
)


class YdoModerationExportFromKikimr(YdoMutlihostTask):
    class Parameters(generate_view(moderation_ops=YdoModerationOpsExecutable, features=YdoFeaturesJson, check_owner=True, with_environ=True)):
        with sdk2.parameters.Group('Kikimr parameters') as kikimr_block:
            kikimr_host = sdk2.parameters.String('Host', required=True)
            kikimr_port = sdk2.parameters.String('Grpc port', required=True)
            kikimr_database = sdk2.parameters.String('Database', required=True)
            kikimr_home = sdk2.parameters.String('Home', required=True)

        users_batch = sdk2.parameters.Resource(
            "Users batch",
            resource_type=YdoModerationUsersBatch,
            required=True,
        )

        timestamp = sdk2.parameters.Integer(
            "Now timestamp",
            required=True
        )

        wait_interval = sdk2.parameters.Integer(
            "Moderation wait interval",
            required=True
        )

        with sdk2.parameters.Output:
            data_file_id = sdk2.parameters.Integer(
                "Data file resource",
                required=True
            )
            commit_file_id = sdk2.parameters.Integer(
                "Commit file resource",
                required=True
            )

    def on_prepare(self):
        pass

    def on_execute(self):
        data_file_resource = YdoModerationDataFile(self, "from task: {}".format(self.id), "data.ysonl")
        data_file = sdk2.ResourceData(data_file_resource)

        commit_file_resource = YdoModerationCommitFile(self, "from task: {}".format(self.id), "commit.tsv")
        commit_file = sdk2.ResourceData(commit_file_resource)

        users_batch_file = sdk2.ResourceData(self.Parameters.users_batch)

        cmd = [
            self.Parameters.moderation_ops_path,
            "export",
            "--ydb_host", self.Parameters.kikimr_host,
            "--ydb_port", self.Parameters.kikimr_port,
            "--ydb_database", self.Parameters.kikimr_database,
            "--ydb_home", self.Parameters.kikimr_home,
            "--input", str(users_batch_file.path),
            "--data-file", str(data_file.path),
            "--commit-file", str(commit_file.path),
            "--timestamp", str(self.Parameters.timestamp),
            "--wait-interval", str(self.Parameters.wait_interval),

            "--features", self.Parameters.features_path,
        ]

        execute_cmd(cmd, "ydo_moderation_ops export", "Export failed", env=self.Parameters.get_environ())

        data_file_resource.line_count = wc_lines(self, str(data_file.path))
        commit_file_resource.line_count = wc_lines(self, str(commit_file.path))

        data_file.ready()
        commit_file.ready()

        self.Parameters.data_file_id = data_file_resource.id
        self.Parameters.commit_file_id = commit_file_resource.id
