import os

from sandbox import sdk2

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.default_multislot_task import YdoMutlihostTask
from sandbox.projects.ydo.parameters_view import generate_view
from sandbox.projects.ydo.moderation import wc_lines, YdoModerationOpsExecutable, YdoModerationUsersBatch


class YdoModerationGetUsersBatch(YdoMutlihostTask):
    class Parameters(generate_view(moderation_ops=YdoModerationOpsExecutable, check_owner=True, with_environ=True)):
        batch_size = sdk2.parameters.Integer('Batch size', default=1000, required=True)
        worker_id_pattern = sdk2.parameters.String("worker_id regexp pattern for sending to moderation")

        with sdk2.parameters.Group('Kikimr parameters') as kikimr_block:
            kikimr_host = sdk2.parameters.String('Host', required=True)
            kikimr_port = sdk2.parameters.String('Grpc port', required=True)
            kikimr_database = sdk2.parameters.String('Database', required=True)
            kikimr_table = sdk2.parameters.String('Table', required=True)

        with sdk2.parameters.Group('YT parameters') as yt_block:
            yt_backup_folder = sdk2.parameters.String('Folder', required=True)

        with sdk2.parameters.Output:
            result_id = sdk2.parameters.Integer('Users batch resource_id')

    def on_execute(self):
        result = YdoModerationUsersBatch(self, 'from task: {}'.format(self.id), 'users_batch.tsv')
        result_data = sdk2.ResourceData(result)
        result_path = str(result_data.path)

        home, table = os.path.split(self.Parameters.kikimr_table)
        cmd = [
            self.Parameters.moderation_ops_path,
            'get_users_batch',
            '--host',
            self.Parameters.kikimr_host,
            '--port',
            self.Parameters.kikimr_port,
            '--database',
            self.Parameters.kikimr_database,
            '--home',
            home,
            '--table',
            table,
            '--folder',
            self.Parameters.yt_backup_folder,
            '--batch-size',
            str(self.Parameters.batch_size),
            '--output',
            result_path,
        ] + (["--worker_id_pattern", self.Parameters.worker_id_pattern] if self.Parameters.worker_id_pattern else [])

        execute_cmd(
            cmd, 'get_users_batch', 'get_users_batch Failed', fail_on_error=False, env=self.Parameters.get_environ()
        )

        lines = wc_lines(self, result_path)
        if lines != 0:
            result.line_count = lines
            result_data.ready()
            self.Parameters.result_id = result.id
