from sandbox import sdk2

from sandbox.projects.ydo import execute_cmd, YdoFeaturesJson

from sandbox.projects.ydo.default_multislot_task import YdoMutlihostTask

from sandbox.projects.ydo.parameters_view import generate_view

from sandbox.projects.ydo.moderation import (
    wc_lines,
    YdoModerationDataFile,
    YdoModerationOpsExecutable,
    YdoModerationSearchAsyncApiConfig,
)


class YdoModerationImportFromYang(YdoMutlihostTask):
    class Parameters(generate_view(
        moderation_ops=YdoModerationOpsExecutable,
        features=YdoFeaturesJson,
        search_async_api_config=YdoModerationSearchAsyncApiConfig,
        check_owner=True,
        with_environ=True,
    )):
        with sdk2.parameters.Group('Kikimr parameters') as kikimr_block:
            kikimr_host = sdk2.parameters.String('Host', required=True)
            kikimr_port = sdk2.parameters.String('Grpc port', required=True)
            kikimr_database = sdk2.parameters.String('Database', required=True)
            kikimr_home = sdk2.parameters.String('Home', required=True)

        input_file = sdk2.parameters.Resource(
            "Input file",
            resource_type=YdoModerationDataFile,
            required=True
        )

        use_rt_indexer = sdk2.parameters.Bool('Use RT indexer', default=False)

        with sdk2.parameters.Output:
            filter_file_id = sdk2.parameters.Integer(
                "Filter file resource",
                required=True
            )
            org_filter_file_id = sdk2.parameters.Integer(
                "Org filter file resource",
                required=True
            )
            error_file_id = sdk2.parameters.Integer(
                "Error file resource",
                required=True
            )

    def on_prepare(self):
        pass

    def on_execute(self):
        error_file_resource = YdoModerationDataFile(self, "error from task: {}".format(self.id), "error.ysonl")
        error_file = sdk2.ResourceData(error_file_resource)

        filter_file_resource = YdoModerationDataFile(self, "filter from task: {}".format(self.id), "filter.ysonl")
        filter_file = sdk2.ResourceData(filter_file_resource)

        org_filter_file_resource = YdoModerationDataFile(self, "org filter from task: {}".format(self.id), "org_filter.ysonl")
        org_filter_file = sdk2.ResourceData(org_filter_file_resource)

        input_file = sdk2.ResourceData(self.Parameters.input_file)

        cmd = [
            self.Parameters.moderation_ops_path,
            "yang_import",
            "--ydb_host", self.Parameters.kikimr_host,
            "--ydb_port", self.Parameters.kikimr_port,
            "--ydb_database", self.Parameters.kikimr_database,
            "--ydb_home", self.Parameters.kikimr_home,
            "--input", str(input_file.path),
            "--error-file", str(error_file.path),
            "--filter-file", str(filter_file.path),
            "--org-filter-file", str(org_filter_file.path),

            "--features", self.Parameters.features_path,
        ] + (["--search_async_api_config", self.Parameters.search_async_api_config_path] if self.Parameters.use_rt_indexer else [])

        execute_cmd(cmd, "ydo_moderation_ops yang_import", "Import failed", env=self.Parameters.get_environ())

        error_file_resource.line_count = wc_lines(self, str(error_file.path))
        filter_file_resource.line_count = wc_lines(self, str(filter_file.path))
        org_filter_file_resource.line_count = wc_lines(self, str(org_filter_file.path))

        error_file.ready()
        filter_file.ready()
        org_filter_file.ready()

        self.Parameters.error_file_id = error_file_resource.id
        self.Parameters.filter_file_id = filter_file_resource.id
        self.Parameters.org_filter_file_id = org_filter_file_resource.id
