from sandbox import sdk2

from sandbox.projects.ydo import execute_cmd, YdoFeaturesJson

from sandbox.projects.ydo.default_multislot_task import YdoMutlihostTask

from sandbox.projects.ydo.parameters_view import generate_view

from sandbox.projects.ydo.moderation import (
    wc_lines,
    YdoModerationDataFile,
    YdoModerationCommitFile,
    YdoModerationOpsExecutable,
)


class YdoModerationPrepareRows(YdoMutlihostTask):
    class Parameters(generate_view(moderation_ops=YdoModerationOpsExecutable, features=YdoFeaturesJson, check_owner=True, with_environ=True)):
        commit_file = sdk2.parameters.Resource(
            "Commit file",
            resource_type=YdoModerationCommitFile,
            required=True,
        )

        data_file = sdk2.parameters.Resource(
            "Data file",
            resource_type=YdoModerationDataFile,
            required=True,
        )

        with sdk2.parameters.Output:
            export_file_id = sdk2.parameters.Integer(
                "Export file resource",
                required=True
            )
            org_export_file_id = sdk2.parameters.Integer(
                "Org export file resource",
                required=True
            )
            approve_file_id = sdk2.parameters.Integer(
                "Approve file resource",
                required=True
            )

    def on_prepare(self):
        pass

    def on_execute(self):
        export_file_resource = YdoModerationDataFile(self, "export from task: {}".format(self.id), "export.ysonl")
        export_file = sdk2.ResourceData(export_file_resource)

        org_export_file_resource = YdoModerationDataFile(self, "org_export from task: {}".format(self.id), "org_export.ysonl")
        org_export_file = sdk2.ResourceData(org_export_file_resource)

        approve_file_resource = YdoModerationDataFile(self, "approve from task: {}".format(self.id), "approve.ysonl")
        approve_file = sdk2.ResourceData(approve_file_resource)

        data_file = sdk2.ResourceData(self.Parameters.data_file)
        commit_file = sdk2.ResourceData(self.Parameters.commit_file)

        cmd = [
            self.Parameters.moderation_ops_path,
            "prepare_rows",
            "--data-file", str(data_file.path),
            "--commit-file", str(commit_file.path),

            "--export-file", str(export_file.path),
            "--org-export-file", str(org_export_file.path),
            "--mail-file", 'None',
            "--approve-file", str(approve_file.path),

            "--features", self.Parameters.features_path,
        ]

        execute_cmd(cmd, "ydo_moderation_ops prepare_rows", "Prepare rows failed", env=self.Parameters.get_environ())

        export_file_resource.line_count = wc_lines(self, str(export_file.path))
        org_export_file_resource.line_count = wc_lines(self, str(org_export_file.path))
        approve_file_resource.line_count = wc_lines(self, str(approve_file.path))

        export_file.ready()
        org_export_file.ready()
        approve_file.ready()

        self.Parameters.export_file_id = export_file_resource.id
        self.Parameters.org_export_file_id = org_export_file_resource.id
        self.Parameters.approve_file_id = approve_file_resource.id
