from sandbox import sdk2

from sandbox.projects.ydo import execute_cmd

from sandbox.projects.ydo.default_multislot_task import YdoMutlihostTask

from sandbox.projects.ydo.parameters_view import generate_view

from sandbox.projects.ydo.moderation import (
    YdoModerationDataFile,
    YdoModerationOpsExecutable,
)


class YdoModerationSendEmails(YdoMutlihostTask):
    class Parameters(generate_view(moderation_ops=YdoModerationOpsExecutable, check_owner=True, with_environ=True)):
        with sdk2.parameters.Group('Kikimr parameters') as kikimr_block:
            kikimr_host = sdk2.parameters.String('Host', required=True)
            kikimr_port = sdk2.parameters.String('Grpc port', required=True)
            kikimr_database = sdk2.parameters.String('Database', required=True)
            kikimr_home = sdk2.parameters.String('Home', required=True)

        delay = sdk2.parameters.Integer("Delay", default=5 * 3600)

        mail_file = sdk2.parameters.Resource(
            "Mail file",
            resource_type=YdoModerationDataFile,
            required=True,
        )

        approved_code = sdk2.parameters.String("Approved mail code", required=True)
        refused_code = sdk2.parameters.String("Refused mail code", required=True)

    def on_execute(self):
        with self.memoize_stage.delay:
            raise sdk2.WaitTime(self.Parameters.delay)

        mail_file = sdk2.ResourceData(self.Parameters.mail_file)

        cmd = [
            self.Parameters.moderation_ops_path,
            "send_email",
            "--ydb_host", self.Parameters.kikimr_host,
            "--ydb_port", self.Parameters.kikimr_port,
            "--ydb_database", self.Parameters.kikimr_database,
            "--ydb_home", self.Parameters.kikimr_home,
            "--data-file", str(mail_file.path),
            "--approved-email", str(self.Parameters.approved_code),
            "--refused-email", str(self.Parameters.refused_code),
            "--env-variable", "MAIL_TOKEN",
        ]
        env = self.Parameters.get_environ()
        env["MAIL_TOKEN"] = sdk2.Vault.data(self.owner, "MAIL_TOKEN")

        execute_cmd(cmd, "send_email", "send failed", env=env)
