import os

from sandbox.common.errors import TaskError

from sandbox import sdk2

from sandbox.sdk2.helpers import subprocess as sp, ProcessLog

from sandbox.projects.ydo.moderation import (
    YdoModerationBaseTask,
    YdoModerationDataFile,
)


class YdoModerationUploadExport(YdoModerationBaseTask):
    class Parameters(sdk2.Parameters):
        data_file = sdk2.parameters.Resource(
            "Data file",
            resource_type=YdoModerationDataFile,
            required=True,
        )

        with sdk2.parameters.Group("YT parameters") as yt_block:
            yt_vault_token = sdk2.parameters.String("Your yt token name in vault", default="yt-token", required=True)
            with sdk2.parameters.RadioGroup("Host") as yt_host:
                yt_host.values["hahn"] = yt_host.Value(value="Hahn", default=True)
                yt_host.values["banach"] = yt_host.Value(value="Banach")
            yt_table = sdk2.parameters.String("Table", required=True)

    def get_yt_parameters(self):
        return sdk2.Vault.data(self.owner, self.Parameters.yt_vault_token), self.Parameters.yt_host

    def on_execute(self):
        data = sdk2.ResourceData(self.Parameters.data_file)
        with ProcessLog(self, logger="yt_write") as pl:
            env = os.environ.copy()
            env["YT_TOKEN"], env["YT_PROXY"] = self.get_yt_parameters()
            cat_cmd = [
                "sed", "s/$/;/", str(data.path)
            ]
            write_to_yt_cmd = [
                "yt", "write",
                self.Parameters.yt_table,
                "--format", "yson"
            ]
            cat = sp.Popen(cat_cmd, stdout=sp.PIPE, stderr=pl.stderr, env=env)
            write_to_yt = sp.Popen(write_to_yt_cmd, stdin=cat.stdout, stdout=pl.stdout, stderr=pl.stderr, env=env)

            write_to_yt.communicate()

            if write_to_yt.returncode != 0:
                raise TaskError("Process read_from_yt has failed")
