import os

import sandbox.common.types.client as ctc
from sandbox.common.errors import TaskError

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp, ProcessLog

from sandbox.sandboxsdk import environments

from sandbox.projects.ydo import ydo_releasers
from sandbox.projects.ydo.kikimr import YdoKikimrBaseTask


def wc_lines(task, path):
    with ProcessLog(task, logger="wc_run") as wc_pl, ProcessLog(task, logger="awk_run") as awk_pl:
        awk_cmd = ["awk", "1", path]
        wc_cmd = ["wc", "-l"]
        awk = sp.Popen(awk_cmd, stdout=sp.PIPE, stderr=awk_pl.stderr)
        wc = sp.Popen(wc_cmd, stdin=awk.stdout, stdout=sp.PIPE, stderr=wc_pl.stderr)
        stdout, stderr = wc.communicate()

        assert wc.returncode == 0
        return int(stdout.split()[0])


class YdoModerationBaseTask(YdoKikimrBaseTask):
    class Requirements(sdk2.Requirements):
        environments = [
            environments.PipEnvironment("yandex-yt", "0.9.17", use_wheel=True),
            environments.PipEnvironment("yandex-yt-yson-bindings", "0.3.1.post0", use_wheel=True),
            environments.PipEnvironment("yandex-yt-yson-bindings-skynet", "0.3.7.post1", use_wheel=True),
        ]
        client_tags = ctc.Tag.GENERIC & ctc.Tag.LINUX_PRECISE

    def prepare_env(self):
        with ProcessLog(self, logger="prepare_base_environment") as pl:
            yt_path = os.path.expanduser("~/.local/bin/yt")
            cmd = ["chmod", "u=rwx,g=rx,o=rx", yt_path]
            if sp.Popen(cmd, stdout=pl.stdout, stderr=pl.stderr).wait() != 0:
                raise TaskError("\"chmod yt\" error")

    def wc_lines(self, path):
        return wc_lines(self, path)

    def on_prepare(self):
        self.prepare_env()

    def on_execute(self):
        self.suspend()


class YdoModerationUsersBatch(sdk2.Resource):
    line_count = sdk2.Attributes.Integer('Line count')


class YdoModerationDataFile(sdk2.Resource):
    line_count = sdk2.Attributes.Integer('Line count')


class YdoModerationCommitFile(sdk2.Resource):
    line_count = sdk2.Attributes.Integer('Line count')


class YdoModerationOpsExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoModerationSearchAsyncApiConfig(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers
