from sandbox import sdk2

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo import build
from sandbox.projects.ydo import resource_types
from sandbox.projects.ydo.default_multislot_task import YdoMutlihostTask
from sandbox.projects.ydo.parameters_view import generate_view, with_config
from sandbox.projects.ydo.solomon_mixin import SolomonMixinV2


class YdoCheckProcessesExecutable(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = resource_types.ydo_releasers
    arcadia_build_path = 'ydo/devops/yt_tools/check_processes/bin'
    executable = True

    binary_path = sdk2.parameters.String(default='check_processes')


class BuildYdoCheckProcessesExecutable(build.YdoYaMakeTemplate):
    class Parameters(build.get_project_params([YdoCheckProcessesExecutable])):
        pass


class YdoCheckProcesses(YdoMutlihostTask, SolomonMixinV2):
    class Parameters(
        with_config(
            generate_view(
                check_processes=YdoCheckProcessesExecutable, check_owner=True, with_environ=True,
                default_secret_env_vars={
                    'YT_TOKEN': 'yt-token',
                    'JUGGLER_TOKEN': 'JUGGLER_TOKEN',
                }
            ),
            'ydo/devops/yt_tools/check_processes/bin',
            [
                ('default', 'config.yaml'),
            ]
        )
    ):
        slow_check = sdk2.parameters.Bool('Run slow checks', default=False)

    def on_execute(self):
        cmd = [self.Parameters.check_processes_path, '--config', self.Parameters.config_path, '--log-to-stderr']
        if self.Parameters.slow_check:
            cmd.append('--slow-check')
        execute_cmd(cmd, 'check_processes', 'check_processes failed', env=self.Parameters.get_environ(), fail_on_error=False)

    def on_break(self, *args, **kwargs):
        SolomonMixinV2.on_break(self, *args, **kwargs)
        super(YdoCheckProcesses, self).on_break(*args, **kwargs)

    def on_finish(self, *args, **kwargs):
        SolomonMixinV2.on_finish(self, *args, **kwargs)
        super(YdoCheckProcesses, self).on_finish(*args, **kwargs)
