from sandbox import sdk2

from sandbox.projects.ydo import execute_cmd, ydo_releasers
from sandbox.projects.ydo.parameters_view import generate_view


class YdoNewInterestingOrdersAdditionalNotifierExecutable(sdk2.Resource):
    """
        Find recent orders without reactions and top workers for them
    """
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoNewInterestingOrdersAdditionalNotifier(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(generate_view(ydo_new_interesting_orders_additional_notifier_executable=YdoNewInterestingOrdersAdditionalNotifierExecutable, check_owner=True, with_environ=True)):
        db_backup_path = sdk2.parameters.String('YT dir with database backup')
        search_index_path = sdk2.parameters.String('YT table with search index')
        locks_kv_path = sdk2.parameters.String('YT table with kv info')
        top_size = sdk2.parameters.Integer('Top size')
        top_score_thr = sdk2.parameters.Float('Top threshold')
        delay_from_order_creation = sdk2.parameters.Integer('Time since order creation (in min)', default=120)

        ydb_host = sdk2.parameters.String('YDB host', required=True)
        ydb_port = sdk2.parameters.Integer('YDB port', default=2135)
        ydb_database = sdk2.parameters.String('YDB database', required=True)
        ydb_home = sdk2.parameters.String('YDB home', required=True)

        yt_proxy = sdk2.parameters.String('YT proxy', default='hahn')

    def on_execute(self):
        cmd = [
            self.Parameters.ydo_new_interesting_orders_additional_notifier_executable_path,

            '--db_backup_path', self.Parameters.db_backup_path,
            '--search_index_path', self.Parameters.search_index_path,
            '--locks_kv_path', self.Parameters.locks_kv_path,
            '--top_size', str(self.Parameters.top_size),
            '--top_score_thr', str(self.Parameters.top_score_thr),
            '--delay_from_order_creation', str(self.Parameters.delay_from_order_creation),

            '--ydb_host', self.Parameters.ydb_host,
            '--ydb_port', str(self.Parameters.ydb_port),
            '--ydb_database', self.Parameters.ydb_database,
            '--ydb_home', self.Parameters.ydb_home,
            '--yt_proxy', self.Parameters.yt_proxy,
        ]

        execute_cmd(cmd, 'new_interesting_orders_additional_notifier', 'new_interesting_orders_additional_notifier failed', env=self.Parameters.get_environ())
