import datetime

from sandbox import sdk2
from sandbox.projects.ydo import ydo_releasers

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view


class YdoNewReviewsNotifierExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoNewReviewsNotifier(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(generate_view(ydo_new_reviews_notifier=YdoNewReviewsNotifierExecutable, check_owner=True, with_environ=True)):
        with sdk2.parameters.Group('KIKIMR_CONNECTION'):
            ydb_host = sdk2.parameters.String('Host', required=True)
            ydb_home = sdk2.parameters.String('Home', required=True)
            ydb_database = sdk2.parameters.String('Database', required=True)
            ydb_port = sdk2.parameters.Integer('Port', default=2135)
            ydb_retry_count = sdk2.parameters.Integer('RetryCount', default=5)
            ydb_delay = sdk2.parameters.Integer('Delay', default=4)
            ydb_backoff = sdk2.parameters.Integer('Backoff', default=2)
            ydb_limit = sdk2.parameters.Integer('Limit', default=15)
        with sdk2.parameters.Group('YT_TABLES'):
            yt_workers = sdk2.parameters.String('Workers', required=True)
            yt_puid_to_worker = sdk2.parameters.String('PuidToWorker', required=True)
            yt_categories = sdk2.parameters.String('Categories', required=True)
        tvm_id = sdk2.parameters.Integer('TVM id')
        tvm_token_name = sdk2.parameters.String('TVM token env variable name')
        blackbox_env = sdk2.parameters.String('Blackbox env', choices=[('test', 'test'), ('mimino', 'mimino'), ('prod', 'prod')])
        from_date = sdk2.parameters.String('Date in a format "YYYY-mm-dd"')
        days_delay = sdk2.parameters.Integer('Days delay for ugc export')
        logging_config = sdk2.parameters.String('LoggingConfig')
        max_review_to_process = sdk2.parameters.Integer('Max reviews to process')

    def add_param_to_cmd(self, cmd, name, parameter):
        if parameter:
            cmd += [name, parameter]

    def on_execute(self):
        cmd = []
        self.add_param_to_cmd(cmd, '--logging-config', self.Parameters.logging_config)
        cmd += [
            self.Parameters.ydo_new_reviews_notifier_path,
            '--kikimr-host', self.Parameters.ydb_host,
            '--kikimr-home', self.Parameters.ydb_home,
            '--kikimr-database', self.Parameters.ydb_database,
            '--kikimr-port', str(self.Parameters.ydb_port),
            '--workers', self.Parameters.yt_workers,
            '--puid-to-worker', self.Parameters.yt_puid_to_worker,
        ]
        self.add_param_to_cmd(cmd, '--kikimr-retry-count', str(self.Parameters.ydb_retry_count))
        self.add_param_to_cmd(cmd, '--kikimr-delay', str(self.Parameters.ydb_delay))
        self.add_param_to_cmd(cmd, '--kikimr-backoff', str(self.Parameters.ydb_backoff))
        self.add_param_to_cmd(cmd, '--kikimr-limit', str(self.Parameters.ydb_limit))
        self.add_param_to_cmd(cmd, '--date', self.Parameters.from_date or datetime.datetime.utcnow().strftime('%Y-%m-%d'))
        self.add_param_to_cmd(cmd, '--days-delay', str(self.Parameters.days_delay))
        self.add_param_to_cmd(cmd, '--tvm_id', str(self.Parameters.tvm_id))
        self.add_param_to_cmd(cmd, '--tvm_token_name', str(self.Parameters.tvm_token_name))
        self.add_param_to_cmd(cmd, '--blackbox_env', str(self.Parameters.blackbox_env))
        self.add_param_to_cmd(cmd, '--categories', self.Parameters.yt_categories)
        self.add_param_to_cmd(cmd, '--max_review_to_process', str(self.Parameters.max_review_to_process))
        execute_cmd(cmd, 'new_reviews_notifier', 'new_reviews_notifier failed', env=self.Parameters.get_environ())
