import datetime

from sandbox import sdk2
from sandbox.projects.ydo import ydo_releasers

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view


class YdoOrderActionsNotifierExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoOrderActionsNotifier(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(generate_view(ydo_order_actions_notifier=YdoOrderActionsNotifierExecutable, check_owner=True, with_environ=True)):
        with sdk2.parameters.Group('KIKIMR_CONNECTION'):
            ydb_host = sdk2.parameters.String('Host', required=True)
            ydb_home = sdk2.parameters.String('Home', required=True)
            ydb_database = sdk2.parameters.String('Database', required=True)
            ydb_port = sdk2.parameters.Integer('Port', default=2135)
            ydb_retry_count = sdk2.parameters.Integer('RetryCount', default=5)
            ydb_delay = sdk2.parameters.Integer('Delay', default=4)
            ydb_backoff = sdk2.parameters.Integer('Backoff', default=2)
            ydb_limit = sdk2.parameters.Integer('Limit', default=15)
        with sdk2.parameters.Group('YT_TABLES'):
            yt_orders = sdk2.parameters.String('Orders', required=True)
            yt_orders_aux = sdk2.parameters.String('OrdersAux', required=True)
            yt_order_reactions = sdk2.parameters.String('OrderReactions', required=True)
            yt_customer_attributes = sdk2.parameters.String('Customer Attributes', required=True)
        with sdk2.parameters.Group('EXP_FLAGS'):
            exp_flags_host = sdk2.parameters.String('Host')
            exp_flags_service = sdk2.parameters.String('Service')
            exp_flags_context = sdk2.parameters.String('Context')
            exp_flags_timeout = sdk2.parameters.Integer('Timeout')
            exp_flags_connection_timeout = sdk2.parameters.Integer('ConnectionTimeout')
        with sdk2.parameters.Group('TVM'):
            tvm_id = sdk2.parameters.Integer('TVM id', required=True)
            tvm_token_name = sdk2.parameters.String('TVM token env variable name', required=True)
        host = sdk2.parameters.String('Host', choices=[('test', 'shared-dev.hamster.yandex.ru'), ('prod', 'ydo-internal.yandex.net')])
        from_date = sdk2.parameters.String('FromDate in a format "YYYY-mm-dd"')
        logging_config = sdk2.parameters.String('LoggingConfig')

    def add_param_to_cmd(self, cmd, name, parameter):
        if parameter:
            cmd += [name, parameter]

    def on_execute(self):
        cmd = []
        self.add_param_to_cmd(cmd, '--logging-config', self.Parameters.logging_config)
        cmd += [
            self.Parameters.ydo_order_actions_notifier_path, 'main',
            '--kikimr-host', self.Parameters.ydb_host,
            '--kikimr-home', self.Parameters.ydb_home,
            '--kikimr-database', self.Parameters.ydb_database,
            '--kikimr-port', str(self.Parameters.ydb_port),
            '--orders', self.Parameters.yt_orders,
            '--orders-aux', self.Parameters.yt_orders_aux,
            '--customer_attributes', self.Parameters.yt_customer_attributes,
        ]
        self.add_param_to_cmd(cmd, '--order_reactions', str(self.Parameters.yt_order_reactions))
        self.add_param_to_cmd(cmd, '--kikimr-retry-count', str(self.Parameters.ydb_retry_count))
        self.add_param_to_cmd(cmd, '--kikimr-delay', str(self.Parameters.ydb_delay))
        self.add_param_to_cmd(cmd, '--kikimr-backoff', str(self.Parameters.ydb_backoff))
        self.add_param_to_cmd(cmd, '--kikimr-limit', str(self.Parameters.ydb_limit))
        self.add_param_to_cmd(cmd, '--from-date', self.Parameters.from_date or datetime.datetime.utcnow().strftime('%Y-%m-%d'))
        self.add_param_to_cmd(cmd, '--exp_flags_host', str(self.Parameters.exp_flags_host))
        self.add_param_to_cmd(cmd, '--exp_flags_service', str(self.Parameters.exp_flags_service))
        self.add_param_to_cmd(cmd, '--exp_flags_context', str(self.Parameters.exp_flags_context))
        self.add_param_to_cmd(cmd, '--exp_flags_timeout', str(self.Parameters.exp_flags_timeout))
        self.add_param_to_cmd(cmd, '--exp_flags_connection_timeout', str(self.Parameters.exp_flags_connection_timeout))
        self.add_param_to_cmd(cmd, '--tvm_id', str(self.Parameters.tvm_id))
        self.add_param_to_cmd(cmd, '--tvm_token_name', str(self.Parameters.tvm_token_name))
        self.add_param_to_cmd(cmd, '--host', str(self.Parameters.host))
        execute_cmd(cmd, 'order_actions_notifier', 'order_actions_notifier failed', env=self.Parameters.get_environ())
