from sandbox import sdk2
import sandbox.projects.ydo.process_generator as process_generator
from sandbox.projects.common.nanny import nanny
from sandbox.projects.ydo.self_release.ReleaseParentTask import (
    SelfReleaseOnSuccessMixin,
    SelfReleaseOnSuccessMixinParameters,
)
from sandbox.projects.ydo.solomon_mixin import SolomonByTaskTypeMixin
from sandbox.projects.ydo.resource_types import (
    YdoOrderCustomizerSeoDataJson,
)
from sandbox.projects.ydo import (
    YdoTestingOrderCustomizerJson,
    YdoOrderCustomizerJson,
)


class TaskMixin(process_generator.BaseMixin):
    def _check_input_resources(self):
        has_prod_customizer = self.Parameters.order_customizer_json_prod is not None
        has_testing_customizer = self.Parameters.order_customizer_json_testing is not None

        assert (
            has_prod_customizer or has_testing_customizer
        ), "Either one of passed order_customizer resources must be specified!"
        assert not (
            has_prod_customizer and has_testing_customizer
        ), "Only one of passed order_customizer resources must be specified"

    def get_cmd(self):
        self._check_input_resources()
        order_customizer_json = (
            self.Parameters.order_customizer_json_prod or self.Parameters.order_customizer_json_testing
        )
        order_customizer_json_path = str(sdk2.ResourceData(order_customizer_json).path)
        self.Context.is_testing = self.Parameters.order_customizer_json_prod is None

        ydo_order_customizer_seo_data_json_resource = YdoOrderCustomizerSeoDataJson(
            self, 'order_customizer_seo_data.json', 'ydo_order_customizer_seo_data.json'
        )

        return [
            self.get_binary_path(),
            '--config',
            self.get_config_path(),
            '--order_customizer',
            order_customizer_json_path,
            '--seo_data_output_config',
            str(ydo_order_customizer_seo_data_json_resource.path),
            '--field_errors_output',
            'field_errors.json',
        ]


class ProcessGenerator(process_generator.ProcessGenerator):
    TaskMixinClass = TaskMixin
    SolomonMixinClass = SolomonByTaskTypeMixin


pg = ProcessGenerator(
    'ydo/tools/order_clarifier/config_builder_with_graph_traversal/bin',
    binary_name='config_builder_with_graph_traversal',
    config_spec=process_generator.ConfigSpec(
        'ydo/tools/order_clarifier/config_builder_with_graph_traversal/bin/configs',
        [
            ('production', 'production.yaml'),
            ('testing', 'testing.yaml'),
        ],
        auto_post_process=True,
    ),
    use_yav_secrets=False,
)


class YdoReleaseOrderCustomizerAdditionalsExecutable(pg.generate_resource()):
    pass


class BuildYdoReleaseOrderCustomizerAdditionalsExecutable(
    pg.generate_build_task(YdoReleaseOrderCustomizerAdditionalsExecutable)
):
    pass


task = pg.generata_task(YdoReleaseOrderCustomizerAdditionalsExecutable)


class YdoReleaseOrderCustomizerAdditionals(task, SelfReleaseOnSuccessMixin, nanny.ReleaseToNannyTask2):
    class Requirements(task.Requirements):
        cores = 32

        class Caches(task.Requirements.Caches):
            pass

    class Parameters(task.Parameters):
        self_release_parameters = SelfReleaseOnSuccessMixinParameters()

        order_customizer_json_testing = sdk2.parameters.Resource(
            'order_customizer.json testing',
            resource_type=YdoTestingOrderCustomizerJson,
            required=False,
        )
        order_customizer_json_prod = sdk2.parameters.Resource(
            'order_customizer.json production',
            resource_type=YdoOrderCustomizerJson,
            required=False,
        )

        with sdk2.parameters.Output:
            graph_errors = sdk2.parameters.String('Graph errors')

    def on_execute(self):
        task.on_execute(self)
        with open("field_errors.json") as fin:
            self.Parameters.graph_errors = fin.read()

    def on_release(self, parameters):
        if "release_status" in parameters:
            is_testing_release_target = parameters["release_status"] not in ["stable", "prestable"]
            assert self.Context.is_testing == is_testing_release_target, "Cannot release testing seo data to stable"

        nanny.ReleaseToNannyTask2.on_release(self, parameters)
        sdk2.Task.on_release(self, parameters)

    def on_success(self, prev_status):
        SelfReleaseOnSuccessMixin.on_success(self, prev_status)
        sdk2.Task.on_success(self, prev_status)
