from sandbox import sdk2, common
from sandbox.projects.common.nanny import nanny
import sandbox.common.types.task as ctt

from sandbox.projects.ydo import (
    ydo_releasers,
    execute_cmd,
)
from sandbox.projects.ydo.parameters_view import generate_view_for_yt
from sandbox.projects.ydo.resource_types import (
    YdoFormAnswersGztCompilerExecutable,
    YdoFormAnswersSynonymsGzt,
)
from sandbox.projects.ydo.self_release.ReleaseParentTask import (
    SelfReleaseOnSuccessMixin,
    SelfReleaseOnSuccessMixinParameters,
)

import os


class YdoFormAnswersSynonymsGztBuilderExecutable(sdk2.Resource):
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoFormAnswersSynonymsGztRaw(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoReleaseFormAnswersSynonymsGzt(SelfReleaseOnSuccessMixin, sdk2.Task):
    class Parameters(generate_view_for_yt(
        ydo_form_answers_gzt_compiler=YdoFormAnswersGztCompilerExecutable,
        ydo_form_answers_synonyms_gzt_builder=YdoFormAnswersSynonymsGztBuilderExecutable,
        check_owner=True,
        with_environ=True,
    )):
        self_release_parameters = SelfReleaseOnSuccessMixinParameters()

        builder_additional_cmd_params = sdk2.parameters.String('Additional gzt builder cmd args')
        compiler_additional_cmd_params = sdk2.parameters.String('Additional gzt compiler cmd args')
        synonyms_table_path = sdk2.parameters.String(
            'Path to the synonyms on YT',
            default='//tmp/maxim98/synonyms',
            required=True,
        )
        gzt_protofiles = sdk2.parameters.List(
            'Paths to gzt protofiles',
            default=[
                'kernel/gazetteer/proto',
                'search/wizard/common/thesaurus',
            ],
        )

    def on_execute(self):
        env = self.Parameters.get_environ()

        synonyms_gzt_raw_resource = YdoFormAnswersSynonymsGztRaw(
            self, 'synonyms.gzt', 'synonyms.gzt'
        )

        synonyms_gzt_resource = YdoFormAnswersSynonymsGzt(
            self, 'synonyms.gzt.bin', 'synonyms.gzt.bin'
        )

        builder_cmd_params = [
            self.Parameters.ydo_form_answers_synonyms_gzt_builder_path,
            '--synonyms-table', self.Parameters.synonyms_table_path,
            '--synonyms-gzt', str(synonyms_gzt_raw_resource.path),
        ]
        if self.Parameters.builder_additional_cmd_params:
            builder_cmd_params.extend(self.Parameters.builder_additional_cmd_params.split())
        execute_cmd(builder_cmd_params, 'Build gazetteer', env=env)

        for dir_path in self.Parameters.gzt_protofiles:
            sdk2.svn.Arcadia.export(sdk2.svn.Arcadia.trunk_url(dir_path), path=dir_path, force=True)
        compiler_cmd_params = [
            self.Parameters.ydo_form_answers_gzt_compiler_path,
            str(synonyms_gzt_raw_resource.path),
            str(synonyms_gzt_resource.path),
            '-I', './'
        ]
        if self.Parameters.compiler_additional_cmd_params:
            compiler_cmd_params.extend(self.Parameters.compiler_additional_cmd_params.split())
        execute_cmd(compiler_cmd_params, 'Compile gazetteer', env=env)

    def on_success(self, prev_status):
        SelfReleaseOnSuccessMixin.on_success(self, prev_status)
        sdk2.Task.on_success(self, prev_status)
